% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{analyze.aov}
\alias{analyze.aov}
\title{Analyze aov and anova objects}
\usage{
\method{analyze}{aov}(x, effsize_rules = "field2013", ...)
}
\arguments{
\item{x}{aov object.}

\item{effsize_rules}{Grid for effect size interpretation. See \link[=interpret_omega_sq]{interpret_omega_sq}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze aov and anova objects.
}
\examples{
\dontrun{
library(psycho)

df <- psycho::affective

x <- aov(df$Tolerating ~ df$Salary)
x <- aov(df$Tolerating ~ df$Salary * df$Sex)

x <- anova(lm(df$Tolerating ~ df$Salary * df$Sex))


summary(analyze(x))
print(analyze(x))

df <- psycho::emotion \%>\%
  mutate(Recall = ifelse(Recall == TRUE, 1, 0)) \%>\%
  group_by(Participant_ID, Emotion_Condition) \%>\%
  summarise(Recall = sum(Recall) / n())

x <- aov(Recall ~ Emotion_Condition + Error(Participant_ID), data = df)
x <- anova(lmerTest::lmer(Recall ~ Emotion_Condition + (1 | Participant_ID), data = df))
analyze(x)
summary(x)
}

}
\references{
\itemize{
 \item{Levine, T. R., & Hullett, C. R. (2002). Eta squared, partial eta squared, and misreporting of effect size in communication research. Human Communication Research, 28(4), 612-625.}
 \item{Pierce, C. A., Block, R. A., & Aguinis, H. (2004). Cautionary note on reporting eta-squared values from multifactor ANOVA designs. Educational and psychological measurement, 64(6), 916-924.}
}
}
\seealso{
http://imaging.mrc-cbu.cam.ac.uk/statswiki/FAQ/os2
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
