% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{estimate_rel_sb}
\alias{estimate_rel_sb}
\title{Spearman-Brown prophecy formula to estimate the reliability of a lengthened measure}
\usage{
estimate_rel_sb(rel_initial, k)
}
\arguments{
\item{rel_initial}{Initial reliability of a measure.}

\item{k}{The number of times by which the measure should be lengthened (if k > 1) or shortened (if k < 1), assuming that all new items are parallel forms of initial items.}
}
\value{
The estimated reliability of the lengthened (or shortened) measure.
}
\description{
This function implements the Spearman-Brown prophecy formula for estimating the reliability of a lengthened (or shortened) measure.
The formula implemented here assumes that all items added to (or subtracted from) the measure will be parallel forms of the original items.
}
\details{
This is computed as:

\deqn{\rho_{XX}^{*}=\frac{k\rho_{XX}}{1+(k-1)\rho_{XX}}}{rel_predicted = (k * rel_initial) / (1 + (k - 1) * rel_initial)}

where \eqn{\rho_{XX}}{rel_initial} is the initial reliability, \emph{k} is the multiplier by which the measure is to be lengthened (or shortened), and \eqn{\rho_{XX}^{*}}{rel_predicted} is the predicted reliability of a measure with a different length.
}
\examples{
## Double the length of a measure with an initial reliability of .7
estimate_rel_sb(rel_initial = .7, k = 2)

## Halve the length of a measure with an initial reliability of .9
estimate_rel_sb(rel_initial = .9, k = .5)
}
\references{
Ghiselli, E. E., Campbell, J. P., & Zedeck, S. (1981).
\emph{Measurement theory for the behavioral sciences}.
San Francisco, CA: Freeman. p. 232.
}
