% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1_cox.R
\name{D1_cox}
\alias{D1_cox}
\title{D1 method for Predictor selection called by psfmi_cox}
\usage{
D1_cox(data, impvar, nimp, fm, names.var)
}
\arguments{
\item{data}{Data frame or data matrix with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the dataset.}

\item{impvar}{A character vector. Name of the variable that distinguishes the imputed datasets.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{fm}{regression formula from coxph object}

\item{names.var}{list of predictors included in pooled regression model}
}
\description{
\code{D1_cox} D1 pooling method
}
\examples{
 
 D1_cox(data=lbpmicox, nimp=5, impvar="Impnr", 
 fm=survival::Surv(Time, Status) ~ Duration + Radiation + Onset,
 names.var=list("Duration", "Radiation", "Onset"))

}
