#' Women National Basketball Association 2014 (WNBA 2014).
#'
#' @description The data set contains information about the season 2014.
#'     The data can be seen in 'Polygonal data analysis: A new framework in symbolic data analysis' paper.
#'
#' @format A data.frame with 4022 rows and 6 variables:
#' \describe{
#'   \item{player_id}{Identification of player.}
#'   \item{team_pts}{Number of points made by team.}
#'   \item{opp_pts}{Number of points made by opponent.}
#'   \item{minutes}{Minutes played.}
#'   \item{fgatt}{Field goal attempts.}
#'   \item{efficiency}{Efficiency.}
#' }
#' @source \url{https://www.sciencedirect.com/science/article/pii/S0950705118304052}
"wnba2014"

#' Airfares data (longair)
#'
#' @description Longair data contains about quarterly average airfare and average weekly passengers
#' for 4177 markets in 2001 of the U.S. Department of Transportation.
#' The data can be seen in 'Polygonal data analysis: A new framework in symbolic data analysis' paper.
#'
#' @format A data.frame with 1000 rows and 11 variables:
#' \describe{
#'   \item{city1}{City of boarding.}
#'   \item{cit2}{City of landing.}
#'   \item{average_fare}{Average fare.}
#'   \item{distance}{Distance between city of boarding and landing.}
#'   \item{average_weekly_passengers}{Average weekly passengers.}
#'   \item{market_leading_airline}{Market leading airline.}
#'   \item{market_share}{Market share.}
#'   \item{avarege_return_fare}{Average return fare}
#'   \item{low_price_airline}{Lower price airline.}
#'   \item{market_share2}{Second market share}
#'   \item{price}{Price of travel.}
#' }
#' @source \url{https://www.sciencedirect.com/science/article/pii/S0950705118304052}
"longair"