% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{create_data_simulation}
\alias{create_data_simulation}
\title{Data Simulation}
\usage{
create_data_simulation(
  baseline,
  coefficients = numeric(),
  treatment_hr = 1,
  drift_hr = 1,
  event_dist,
  fixed_external_data
)
}
\arguments{
\item{baseline}{\code{BaselineObject} from \code{\link[=create_baseline_object]{create_baseline_object()}}}

\item{coefficients}{Named vector of coefficients for linear predictor. Must correspond to variables in baseline
object}

\item{treatment_hr}{Default treatment hazard ratio for simulations. Alternative simulation settings can be specified
in \link{generate}.}

\item{drift_hr}{Default drift hazard ratio between internal and external arms. Alternative simulation settings can be
specified in \link{generate}.}

\item{event_dist}{Specify time to event distribution with \code{SimDataEvent} object from \code{\link[=create_event_dist]{create_event_dist()}}}

\item{fixed_external_data}{A \code{data.frame} containing external control data. It must contain columns \code{eventtime},
\code{status} and all of the variables named in \code{coefficients}. If present, \code{trt} must be 0 and \code{ext} must be 1 for all
rows.}
}
\value{
\code{DataSimObject}
}
\description{
Data Simulation
}
\examples{
baseline_obj <- create_baseline_object(
  n_trt_int = 100,
  n_ctrl_int = 50,
  n_ctrl_ext = 10,
  covariates = baseline_covariates(
    names = c("age", "score"),
    means_int = c(55, 5),
    means_ext = c(60, 5),
    covariance_int = covariance_matrix(c(5, 1))
  )
)
sim_obj <- create_data_simulation(
  baseline_obj,
  coefficients = c(age = 0.001, score = 1.5),
  event_dist = create_event_dist(dist = "exponential", lambdas = 1 / 36)
)
data_sim_list <- generate(sim_obj, treatment_hr = c(0.5, 1), drift_hr = 0.5)
}
