% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_class.R
\docType{class}
\name{Simulation-class}
\alias{Simulation-class}
\alias{.simulation_obj}
\title{\code{Simulation} Class}
\description{
A class for defining Simulation study details. Objects of class
\code{Simulation} should not be created directly but by the constructor
\code{create_simulation_obj()}.
}
\section{Slots}{

\describe{
\item{\code{data_matrix_list}}{\code{SimDataList}. The list of lists of data matrices created
with \code{sim_data_list()}.}

\item{\code{outcome}}{\code{SimOutcomeList}. List of \code{Outcome} objects created with
\code{sim_outcome_list()}.}

\item{\code{borrowing}}{\code{SimBorrowingList}. List of \code{Borrowing} objects created
with \code{sim_borrowing_list()}.}

\item{\code{covariate}}{\code{SimCovariateList} or \code{NULL}. List of \code{Covariate} objects created
with \code{sim_covariate_list()} or \code{NULL} (no covariate adjustment).}

\item{\code{treatment}}{\code{SimTreatmentList}. List of \code{Treatment} objects created
with \code{sim_treatment_list()}.}

\item{\code{guide}}{data.frame. Data.frame containing information on all
combinations evaluated.}

\item{\code{n_combos}}{integer. Number of combinations of parameters to be evaluated.}

\item{\code{n_analyses}}{integer. Number of analyses (combos x datasets to be performed).}

\item{\code{`analysis_obj_list`}}{list. List of analysis objects indexed according to \code{guide}.}
}}

