% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_bernoulli.R
\docType{class}
\name{PriorBernoulli-class}
\alias{PriorBernoulli-class}
\alias{.prior_bernoulli}
\title{\code{PriorBernoulli} Class}
\description{
A class for defining bernoulli priors to be translated to Stan code.
Objects of class \code{PriorBernoulli} should not be created directly but by
the constructor \code{\link[=prior_bernoulli]{prior_bernoulli()}}.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for bernoulli stan function parameters surrounded with
\verb{\{\{} and \verb{\}\}} to be replaced with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters (1).}

\item{\code{constraint}}{character. Support of prior distribution,
\code{"<lower=0, upper=1>"}.}

\item{\code{theta}}{numeric. Probability (in [0, 1]).}
}}

\seealso{
Other prior classes: 
\code{\link{Prior-class}},
\code{\link{PriorBeta-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorExponential-class}},
\code{\link{PriorGamma-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorNormal-class}},
\code{\link{PriorPoisson-class}},
\code{\link{UniformPrior-class}}
}
\concept{prior classes}
