% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCSAcs.R
\name{DCSA}
\alias{DCSA}
\title{Dynamic Changed Subpathway Analysis (DCSA)}
\usage{
DCSA(expr, input.cls = "", subpathwaylist = "Symbol",
  kcdf = "Gaussian", method = "gsva", min.sz = 1, max.sz = Inf,
  nperm = 100, fdr.th = 1, mx.diff = TRUE, parallel.sz = 0)
}
\arguments{
\item{expr}{Matrix of gene expression values (rows are genes, columns are samples).}

\item{input.cls}{Input sample phenotype class vector file in CLS format.}

\item{subpathwaylist}{Character string denoting the gene label of the subpahtway list is `Entrezid` (default) or `Symbol`.
Users can also enter their own subpathway list data. This list should be consistent with the gene label in the input gene expression profile.}

\item{kcdf}{Character string denoting the kernel to use during the non-parametric estimation of the cumulative
distribution function of expression levels across samples when method="gsva". By default, `kcdf="Gaussian"` which
is suitable when input expression values are continuous, such as microarray fluorescent units in logarithmic scale,
RNA-seq log-CPMs, log-RPKMs or log-TPMs. When input expression values are integer counts, such as those derived from
RNA-seq experiments, then this argument should be set to `kcdf="Poisson"`.}

\item{method}{Method to employ in the estimation of subpathway enrichment scores per sample.By default this is set to
`gsva` (Hänzelmann et al, 2013) and other options are `ssgsea` (Barbie et al, 2009).}

\item{min.sz}{Minimum size of the resulting subpathway.}

\item{max.sz}{Maximum size of the resulting subpathway.}

\item{nperm}{Number of random permutations (default: 100).}

\item{fdr.th}{Cutoff value for fdr. Only subpathway with lower fdr.th are listed (default: 1).}

\item{mx.diff}{Offers two approaches to calculate the sample enrichment score (SES) from the KS random walk statistic.
`mx.diff=FALSE`: SES is calculated as the maximum distance of the random walk from 0. `mx.diff=TRUE` (default): SES is
calculated as the magnitude difference between the largest positive and negative random walk deviations.}

\item{parallel.sz}{Number of processors to use when doing the calculations in parallel. If this argument is left with its
default value (parallel.sz=0) then it will use all available core processors unless we set this argument with a smaller number.}
}
\value{
A list containing the results of DCSA and subpathway activity profile.
}
\description{
This function will perform the Dynamic Changed Subpathway Analysis (DCSA) method to estimate the dynamic
changed subpathways associated with the sample phenotypes (like developmental stage of cancer).
}
\details{
DCSA


This function constructs a subpathway activity profile  by using subpathway list and gene expression
profiling as input to the GSVA method. Next,we used the information theoretic measure of statistical dependence,
mutual information (MI), to estimate the dynamic changed subpathways associated with the sample phenotypes.
Finally we used the perturbation analysis of the gene label rearrangement to estimating the statistical significance.
}
\examples{
# load depend package.
require(GSVA)
require(parallel)
require(mpmi)
# get ACC disease stage gene expression profiling.
ACCgenematrix<-get("DCgenematrix")
# get path of the sample disease stage phenotype files.
Stagelabels<-system.file("extdata", "DClabels.cls", package = "psSubpathway")
# perform the DCSA method.
\donttest{DCSA(ACCgenematrix,input.cls=Stagelabels,nperm=50,fdr.th=0.01,parallel.sz=2)}
# get the result of the SubSEA function
DCSAresult<-get("DCspwresult")
str(DCSAresult)
head(DCSAresult$DCSA)

# Simulated gene matrix.
genematrix <- matrix(rnorm(500*40), nrow=500, dimnames=list(1:500, 1:40))
# Construct subpathway list data.
subpathwaylist <- as.list(sample(2:100, size=20, replace=TRUE))
subpathwaylist <- lapply(subpathwaylist, function(n) sample(1:500, size=n, replace=FALSE))
names(subpathwaylist)<-c(paste(rep("spw",20),c(1:20)))
# Construct sample labels data.
stagelabel<-list(phen=c("stage1","stage2","stage3","stage4"),
                   class.labes=c(rep("stage1",10),rep("stage2",10),
                   rep("stage3",10),rep("stage4",10)))
DCSAcs<-DCSA(genematrix,stagelabel,subpathwaylist,nperm=10,parallel.sz=1)
str(DCSAcs)

}
\author{
Xudong Han,
Junwei Han,
Qingfei Kong
}
