% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{plot.DZdata}
\alias{plot.DZdata}
\title{Plot continuous data as histograms or cumulative age distributions}
\usage{
\method{plot}{DZdata}(x, snames = NULL, annotate = TRUE, CAD = FALSE,
  pch = NA, verticals = TRUE, col = par("col"), ...)
}
\arguments{
\item{x}{an object of class \code{DZdata}}

\item{snames}{a string or a vector of string with the names of the
samples that need plotting if \code{snames} is a vector, then the
function will default to a CAD.}

\item{annotate}{boolean flag indicating whether the x- and y-axis
should be labeled}

\item{CAD}{boolean flag indicating whether the data should be
plotted as a cumulative age distribution or a histogram. For
multi-sample plots, the function will override this value with
\code{TRUE}.}

\item{pch}{an optional the symbol to mark the sample points along
the CAD}

\item{verticals}{boolean flag indicating if the horizontal lines of
the CAD should be connected by vertical lines}

\item{col}{a colour map}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plot one or several samples from a \code{DZdata} dataset as a
histogram or Cumulative Age Distributions (CAD).
}
\examples{
DZ <- read.DZdata(system.file("DZ.csv",package="provenance"))
plot(DZ,c('N1','N2'),CAD=TRUE)
}

