% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{clr}
\alias{clr}
\alias{clr.HMdata}
\title{Centred logratio transformation}
\usage{
clr(x, ...)

\method{clr}{HMdata}(x, ...)
}
\arguments{
\item{x}{an object of class \code{HMdata}}

\item{...}{optional arguments of the generic function}
}
\value{
a matrix of clr coordinates
}
\description{
Calculates Aitchison's centered logratio transformation for a
dataset of class \code{HMdata}
}
\examples{
fname <- system.file("Major.csv",package="provenance")
Major <- read.HMdata(fname)
clrdat <- clr(Major)$x
diss <- dist(clrdat)
plot(getMDS(diss,classical=TRUE))
}

