% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_protti.R
\name{anova_protti}
\alias{anova_protti}
\title{Perform ANOVA}
\usage{
anova_protti(data, grouping, condition, mean_ratio, sd, n)
}
\arguments{
\item{data}{A data frame containing at least the input variables.}

\item{grouping}{The column in the data frame containing precursor or peptide identifiers.}

\item{condition}{The column in the data frame containing the conditions.}

\item{mean_ratio}{The column in the data frame containing mean intensities or mean intensity ratios.}

\item{sd}{The column in the data frame containing the standard deviation corresponding to the mean.}

\item{n}{The column in the data frame containing the number of replicates for which the corresponding mean was calculated.}
}
\value{
A data frame that contains the within group error (\code{ms_group}) and the between group error (\code{ms_error}), f statistic and p-values.
}
\description{
Performs an ANOVA statistical test
}
\examples{
\dontrun{
anova_protti(
  data,
  grouping = eg_precursor_id,
  condition = r_condition,
  mean = mean,
  sd = sd,
  n = n
)
}
}
