\name{scampiVal-class}
\docType{class}
\alias{scampiVal-class}
\alias{scampiVal}
\alias{plot,scampiVal,missing-method}
\alias{show,scampiVal-method}
\alias{summary,scampiVal-method}

\title{Class \code{"scampiVal"}}

\description{This class of objects is returned by the functions \code{\link{runScampi}} and \code{\link{iterateScampi}} to contain the estimated protein abundances (and optionally the peptie abundance reassessment).
Objects of this class have methods for the functions summary, show and plot.
}

\section{Creation of objects}{
Objects are typically generated by calls to the functions \code{\link{runScampi}} and \code{\link{iterateScampi}} (in latter the \code{scampiVal} class object is in a nested list).
}

\section{Slots}{
  \describe{
    \item{\code{call}:}{Object of the class \code{"call"}: the
          original function call.}
    \item{\code{parameters}:}{Object of class \code{"list"}:
      list of estimated model parameter values, each list element corresponds to 
      a different estimation method.}
    \item{\code{ppGraph}:}{Object of class \code{"graphNEL"}:
      the bipartite undirected graph with peptides and proteins underlying the 
      comuptations.}
    \item{\code{ccList}:}{Object of class \code{"list"}:
      list of connected components (with some pre-processed properties) of 
      \code{ppGraph} underlying the computations.}
    \item{\code{peptides}:}{Object of class \code{"data.frame"}:
      dataframe summarizing information about the peptides (input data as well as 
      (optionally) reassessed abundances).}
    \item{\code{proteins}:}{Object of class \code{"data.frame"}:
      dataframe summarizing information about the proteins (input data as well as estimated
      protein abundances).}
    \item{\code{edgespp}:}{Object of class \code{"data.frame"}:
      dataframe summarizing the information about the edges of \code{ppGraph}, connecting the 
      \code{peptides} to the \code{proteins}.}
  }
}

\section{Extends}{
Class \code{\linkS4class{scampi}}, directly.
}

\section{Methods}{
  \describe{
    \item{plot}{\code{signature(x = "scampiVal", y = "missing")}: For each parameter estimation method, plot the distribution of the computed protein abundance scores (histogram). If the peptide score reassessment was performed, also display a Tukey-Anscombe and Normal Q-Q plot for the peptide residuals.}
    \item{show}{\code{signature(object = "scampiVal")}: Display basic properties of the fitted object}
    \item{summary}{\code{signature(object = "scampiVal")}: Display details of the fitted object }
           }	
}

\author{Sarah Gerster \email{sarah.gerster@isb-sib.ch}}

\seealso{
  \code{\link{runScampi}}, \code{\link{iterateScampi}}
}

\examples{
showClass("scampiVal")

## generate a scampiVal object
data("leptoSRM")
scampiRes <- runScampi(peptides=leptoSRMpeptides, 
                       proteins=leptoSRMproteins, 
                       edgespp=leptoSRMedgespp, 
                       rescaling=FALSE, method="LSE", 
                       quantifyPeptides=FALSE)

## use methods of class scampiVal
show(scampiRes)
summary(scampiRes)
plot(scampiRes)
}

\keyword{classes}
