% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-propdViz.R
\name{pals}
\alias{pals}
\title{Calculate PALs for Pairs}
\usage{
pals(object, k)
}
\arguments{
\item{object}{A \code{propr} or \code{propd} object.}

\item{k}{An integer. For \code{propr} methods, the number
of co-clusters (where all pairs receive a specified color
if and only if both members belong to same the cluster).
For \code{propd} methods, the maximum number of PALs to index
when calculating \code{\link{pals}} in the network.}
}
\value{
A named vector of PALs, ordered by decreasing
 connectivity of the input nodes. The names of the result
 refer to the input nodes themselves.
}
\description{
This function finds the Popular Adjacent Ligand or Self (PALs)
 for each feature in the \code{@results} slot of a \code{propd}
 object. Specifically, we define PALs as the adjacent node with
 the highest amount of connectivity. If node itself has more
 connectivity than any of its neighbors, it is its own PAL.
}
