% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-proprViz.R, R/6-propdViz.R
\docType{methods}
\name{visualize}
\alias{visualize}
\alias{plot,propr,missing-method}
\alias{smear}
\alias{dendrogram}
\alias{slate}
\alias{bucket}
\alias{prism}
\alias{bokeh}
\alias{pca}
\alias{snapshot}
\alias{cytescape}
\alias{propd2propr}
\alias{plot,propd,missing-method}
\alias{shale}
\alias{geyser}
\alias{bowtie}
\alias{gemini}
\alias{slice}
\alias{decomposed}
\title{Visualize Proportionality}
\usage{
\S4method{plot}{propr,missing}(x, y, prompt = TRUE, plotly = FALSE)

smear(rho, prompt = TRUE, plotly = FALSE)

dendrogram(rho, prompt = TRUE, plotly = FALSE)

slate(rho, k, prompt = TRUE, plotly = FALSE)

bucket(rho, group, k, prompt = TRUE, plotly = FALSE)

prism(rho, k, prompt = TRUE, plotly = FALSE)

bokeh(rho, k, prompt = TRUE, plotly = FALSE)

pca(rho, group, prompt = TRUE, plotly = FALSE)

snapshot(rho, prompt = TRUE, plotly = FALSE)

cytescape(object, col1, col2, prompt = TRUE, d3 = FALSE)

propd2propr(object, ivar)

\S4method{plot}{propd,missing}(x, y, cutoff = 1000, col1, col2, propr,
  prompt = TRUE, d3 = FALSE, plotSkip = FALSE)

shale(object, cutoff = 1000, k, prompt = TRUE, clean = FALSE)

geyser(object, cutoff = 1000, k = 5, prompt = TRUE, plotly = FALSE)

bowtie(object, cutoff = 1000, k = 5, prompt = TRUE, plotly = FALSE)

gemini(object, cutoff = 1000, k = 5, prompt = TRUE, plotly = FALSE)

slice(object, cutoff = 1000, reference, prompt = TRUE, plotly = FALSE)

decomposed(object, cutoff = 1000, prompt = TRUE)
}
\arguments{
\item{x}{A \code{propr} or \code{propd} object.}

\item{y}{Missing. Ignore. Leftover from the generic
method definition.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the courtesy prompt when working with big data.}

\item{plotly}{A logical scalar. Set to \code{TRUE} to produce
a dynamic plot using the \code{plotly} package.}

\item{rho}{A \code{propr} or \code{propd} object.}

\item{k}{An integer. For \code{propr} methods, the number
of co-clusters (where all pairs receive a specified color
if and only if both members belong to same the cluster).
For \code{propd} methods, the maximum number of PALs to index
when calculating \code{\link{pals}} in the network.}

\item{group}{A character vector. Group or sub-group memberships,
ordered according to the row names in \code{counts}.}

\item{object}{A \code{propr} or \code{propd} object.}

\item{col1}{A character vector. Specifies which nodes
to color \code{red} or \code{blue}, respectively.}

\item{col2}{A character vector. Specifies which nodes
to color \code{red} or \code{blue}, respectively.}

\item{d3}{A boolean. Use \code{rgl} to plot 3D network.}

\item{ivar}{A numeric scalar. Specifies reference feature(s)
for additive log-ratio transformation. The argument will also
accept feature name(s) instead of the index position(s).
Set to "iqlr" to use inter-quartile log-ratio transformation.
Ignore to use centered log-ratio transformation.}

\item{cutoff}{For \code{updateCutoffs}, a numeric vector.
this argument provides the FDR cutoffs to test.
For graph functions, a numeric scalar. This argument
indicates the maximum theta to include in the figure.
For graph functions, a large integer will instead
retrieve the top N pairs as ranked by theta.}

\item{propr}{A \code{propr} or \code{propd} object.}

\item{plotSkip}{A boolean. Toggles whether to build
the network graph without plotting it.
Used by \code{\link{pals}}.}

\item{clean}{A boolean. Toggles whether to remove pairs
with "Bridged" or "Missing" PALs. Used by \code{geyser},
\code{bowtie}, and \code{gemini}.}

\item{reference}{A character string. A feature to use as the
denominator reference when comparing log-ratio abundances.}
}
\description{
Visualize proportionality and differential proportionality.
}
\section{\code{propr} Functions}{

\code{plot:}
 A wrapper for \code{smear(x, ...)}.


\code{smear:}
 Plots log-ratio transformed abundances pairwise.
 Index-aware, meaning that it only plots pairs indexed
 in \code{@pairs}, unless no pairs are indexed.
 Returns a \code{ggplot} object.


\code{dendrogram:}
 Plots a clustering of the proportionality matrix.
 Index-aware, meaning that it only plots pairs indexed
 in \code{@pairs}, unless no pairs are indexed.
 Heatmap intensity is not scaled.
 Returns a \code{dendrogram} object.


\code{slate:}
 Builds a table of VLR, VLS, and proportionality
 for each feature pair in a \code{propr} object. If the
 argument \code{k} is provided, the table will also
 include co-cluster membership.
 Returns a \code{data.frame} of all pairwise relationships.
 If the argument \code{k} is provided, returns a list of
 the \code{data.frame} of pairwise relationships and the
 cluster membership.


\code{bucket:}
 Plots an estimation of the degree to which a feature pair
 differentiates the experimental groups versus the
 measure of the proportionality between that feature pair.
 The discrimination score is defined as the negative
 log of the p-values for each feature in the pair,
 computed independently using \code{kruskal.test}.
 "It's pronounced, 'bouquet'." - Hyacinth Bucket
 Returns cluster membership if \code{k} is provided.
 Otherwise, returns a \code{ggplot} object.


\code{prism:}
 Plots the variance of the ratio of the log-ratio transformed
 feature pair (VLR) versus the sum of the individual variances
 of each log-ratio transformed feature (VLS). The ratio of
 the VLR to the VLS equals \code{1 - rho}. As such, we use
 here seven rainbow colored lines to indicate where \code{rho}
 equals \code{[.01, .05, .50, 0, 1.50, 1.95, 1.99]}, going
 from red to violet.
 Returns cluster membership if \code{k} is provided.
 Otherwise, returns a \code{ggplot} object.


\code{bokeh:}
 Plots the feature variances for each log-ratio transformed
 feature pair in the \code{propr} object. Highly proportional
 pairs will aggregate near the \code{y = x} diagonal.
 Clusters that appear toward the top-right of the
 figure contain features with highly variable abundance across
 all samples. Clusters that appear toward the
 bottom-left of the figure contain features with fixed
 abundance across all samples. Uses a log scale.
 Returns cluster membership if \code{k} is provided.
 Otherwise, returns a \code{ggplot} object.


\code{pca:}
 Plots the first two principal components as calculated
 using the log-ratio transformed feature vectors. This
 provides a statistically valid alternative to
 conventional principal components analysis (PCA).
 For more information, see <DOI:10.1139/cjm-2015-0821>.
 Returns a \code{ggplot} object.


\code{snapshot:}
 Plots the log-ratio transformed feature abundance as
 a heatmap, along with the respective dendrograms.
 Heatmap intensity is not scaled.
 Returns a \code{dendrogram} object.


\code{cytescape:}
 Builds a table of indexed pairs and their proportionality.
 In doing so, this function displays a preview of the
 interaction network, built using \code{igraph}.
 We recommend using the result as input to a
 network visualization tool like Cytoscape.
 Returns a \code{data.frame} of indexed pairs.
}

\section{\code{propd} Functions}{

\code{propd2propr:}
 Transforms a \code{propd} object into a \code{propr} object
 where the \code{@matrix} slot contains \eqn{1 - \theta}.
 Allows the user to interrogate theta using any
 visualization built for \code{propr} objects.


\code{plot:}
 Plots the interactions between pairs as a network.
 When plotting disjointed proportionality, red edges
 indicate that LRM1 > LRM2 while blue edges indicate
 that LRM1 < LRM2. When plotting emergent proportionality,
 red edges indicate that VLR1 < VLR2 while blue edges
 indicate that VLR1 > VLR2. Group labels numbered based on
 the order of the \code{group} argument to \code{propd}.
 Use \code{col1} and \code{col2} arguments to color nodes.
 For more control over the visualization of the network,
 consider exporting the table from \code{shale} to a
 network visualization tool like Cytoscape.


\code{shale:}
 Builds a table of within-group and total log-ratio
 variances, log-ratio means, and PALs (see: \code{\link{pals}}).
 If the argument \code{k} is provided, the table will
 label at most \code{k} top PALs. Just as each node
 gets assigned a PAL, \code{shale} aims to assign
 each edge a PAL. Edges that have a top PAL as one
 and only one of their nodes get assigned that PAL.
 Edges that have top PALs as both of their nodes
 get assigned "Bridged". Edges without a top PAL
 as one of their nodes will get assigned a PAL if
 either (a) both nodes have the same neighbor PAL
 or (b) one node has a "Missing" neighbor PAL.
 The \code{cutoff} argument guides the maximum value of
 theta above which to exclude the pair. A large integer
 \code{cutoff} will instead retrieve the top N pairs as
 ranked by theta.


\code{geyser:}
 Plots indexed pairs based on the within-group
 log-ratio variance (VLR) for each group. Pairs near the
 origin show a highly proportional relationship in
 both groups. Each line away from the \code{y = x} line
 indicates a doubling of VLR compared to the other group.
 All pairs colored based on PAL
 (see: \code{\link{pals}}).
 See \code{gemini}.


\code{bowtie:}
 Plots indexed pairs based on the log-ratio means
 (LRM), relative to its PAL, for each group. Pairs near
 the origin show comparable LRM, relative to its PAL, in
 both groups. Each line away from the \code{y = x} line
 indicates a doubling of LRM compared to the other group.
 All pairs colored based on PAL
 (see: \code{\link{pals}}).
 See \code{gemini}.


\code{gemini:}
 Plots indexed pairs based on the log-fold difference
 in log-ratio variance (VLR) between the two groups
 versus the difference in log-ratio means (LRM). In this
 figure, the LRM for each group is signed (i.e., positive
 or negative) such that the PAL is the denominator
 of the log-ratio. This allows for a fluid comparison
 between pairs within the same PAL module. Pairs with a
 "Bridged" or "Missing" PAL get excluded from this graph.
 Remember that an increase in VLR suggests less
 proportionality. All pairs colored based on PAL
 (see: \code{\link{pals}}).


\code{slice:}
 Plots log-ratio counts relative to a \code{reference}
 node for all pairs that include the reference itself.
 This makes a useful adjunct function to visualize how
 features vary across samples relative to a PAL.


\code{decomposed:}
 Plots the decomposition of log-ratio variance into
 (weighted) group variances and between-group variance.
 Useful for visualizing how a theta type selects pairs.
}

