% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/501.Error-Failure_LimitBased_BASE_All.R
\name{errAll}
\alias{errAll}
\title{Calculates error, long term power and pass/fail criteria using 6 base methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)}
\usage{
errAll(n, alp, phi, f)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{phi}{- Null hypothesis value}

\item{f}{- Failure criterion}
}
\value{
A dataframe with
 \item{delalp}{ Delta-alpha is the increase of the nominal error with respect to real error}
 \item{theta}{ Long term power of the test}
 \item{Fail_Pass}{Fail/pass based on the input f criterion}
 \item{method}{Name of the method }
}
\description{
Calculates error, long term power and pass/fail criteria using 6 base methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\details{
Calculation of error, long term power and pass/fail
criteria using 6 base methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\examples{
n=20; alp=0.05; phi=0.05; f=-2
errAll(n,alp,phi,f)
}
\references{
[1] 2014 Martin Andres, A. and Alvarez Hernandez, M.
Two-tailed asymptotic inferences for a proportion.
Journal of Applied Statistics, 41, 7, 1516-1529
}
\seealso{
Other Error for base methods: \code{\link{PloterrAS}},
  \code{\link{PloterrAll}}, \code{\link{PloterrBA}},
  \code{\link{PloterrEX}}, \code{\link{PloterrLR}},
  \code{\link{PloterrLT}}, \code{\link{PloterrSC}},
  \code{\link{PloterrTW}}, \code{\link{PloterrWD}},
  \code{\link{errAS}}, \code{\link{errBA}},
  \code{\link{errEX}}, \code{\link{errLR}},
  \code{\link{errLT}}, \code{\link{errSC}},
  \code{\link{errTW}}, \code{\link{errWD}}
}

