% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/423.p-Confidence_p-Bias_GENERAL.R
\name{pCOpBIGEN}
\alias{pCOpBIGEN}
\title{Performs p-Confidence and p-Bias estimation only using n,
lower limit and upper limit for general method}
\usage{
pCOpBIGEN(n, LL, UL)
}
\arguments{
\item{n}{- Number of trials}

\item{LL}{- Lower limit}

\item{UL}{- Upper limit}
}
\value{
A dataframe with
\describe{
 \item{x1}{  Number of successes (positive samples)}
 \item{pconf }{   p-Confidence}
 \item{pbias }{   p-Bias}
}
}
\description{
Performs p-Confidence and p-Bias estimation only using n,
lower limit and upper limit for general method
}
\details{
Evaluation of intervals obtained from any method using
p-confidence and p-bias for the  \eqn{n + 1} intervals
}
\examples{
LL=c(0,0.01,0.0734,0.18237,0.3344,0.5492)		#Lower and Upper Limits
UL=c(0.4507,0.6655,0.8176,0.9265,0.9899,1)
n=5;
pCOpBIGEN(n,LL,UL)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
Other General methods for p-Confidence and p-Bias: \code{\link{PlotpCOpBIGEN}}
}

