% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan-todo.R
\name{post_todo}
\alias{post_todo}
\title{Post to-do list (issues) to GitHub repository}
\usage{
post_todo(ref, todo, distinct = TRUE)
}
\arguments{
\item{ref}{Repository reference (list) created by \code{create_repo_ref()}}

\item{todo}{To-do R list structure as read with \code{read_todo()}}

\item{distinct}{Logical value to denote whether issues with the same title
as a current open issue should be allowed. Passed to \code{get_issues()}}
}
\value{
Number (identifier) of posted issue
}
\description{
Post custom to-do lists (i.e. issues) based on yaml read in by \code{read_todo}.
Please see the "Building Custom Plans" vignette for details.
}
\details{
Currently has know bug in that cannot be used to introduce new labels.
}
\examples{
\dontrun{
# This example uses example file included in pkg
# You should be able to run example as-is after creating your own repo reference
file_path <- system.file("extdata", "todo.yml", package = "projmgr", mustWork = TRUE)
my_todo <- read_todo(file_path)
post_todo(ref, my_todo)
}
}
\seealso{
Other plans and todos: 
\code{\link{post_plan}()},
\code{\link{read_plan}()},
\code{\link{read_todo}()},
\code{\link{report_plan}()},
\code{\link{report_todo}()},
\code{\link{template_yaml}()}
}
\concept{plans and todos}
