% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_issue_events}
\alias{parse_issue_events}
\title{Parse issue events from \code{get_issues_events}}
\usage{
parse_issue_events(res)
}
\arguments{
\item{res}{List returned by corresponding \code{get_} function}
}
\value{
Dataframe with one record / issue-event
}
\description{
This function convert list output returned by get into a dataframe. Due to the diverse
fields for different types of events, many fields in the dataframe may be NA.
}
\details{
Currently, the following event types are unsupported (with regard to processing all
of their fields) due to their additional bulk and limited utility with respect to
this packages functionality. Please file an issue if you disagree:
\itemize{
\item (removed_from/moved_columns_in/added_to)_project: Since this package has limited value with GitHub projects
\item converted_note_to_issue: Since issue lineage is not a key concern
\item head_ref_(deleted/restored): Since future support for pull requests would likely be handled separately
\item merged: Same justification as head_ref
\item review_(requested/dismissed/request_removed): Same justification as head_ref
}
}
\examples{
\dontrun{
myrepo <- create_repo_ref('emilyriederer', 'myrepo')
events_res <- get_issue_events(myrepo, number = 1)
events <- parse_issue_events(events_res)
}
}
\seealso{
Other issues: 
\code{\link{get_issue_comments}()},
\code{\link{get_issue_events}()},
\code{\link{get_issues}()},
\code{\link{parse_issue_comments}()},
\code{\link{parse_issues}()},
\code{\link{post_issue_update}()},
\code{\link{post_issue}()},
\code{\link{report_discussion}()},
\code{\link{report_progress}()},
\code{\link{viz_waterfall}()}

Other events: 
\code{\link{get_issue_events}()}
}
\concept{events}
\concept{issues}
