% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report-taskboard.R
\name{report_taskboard}
\alias{report_taskboard}
\title{Report HTML-based task board of item status}
\usage{
report_taskboard(data, in_progress_when, include_link = FALSE,
  hover = FALSE, colors = c("#f0e442", "#56b4e9", "#009e73"))
}
\arguments{
\item{data}{Dataset, such as those representing issues or milestones (i.e. from \code{parse_issues()}).
Must have \code{state} variable.}

\item{in_progress_when}{Function with parameter \code{data} that returns Boolean vector. Generally, one of the
taskboard helper functions. See \code{?taskboard_helpers} for details.}

\item{include_link}{Boolean whether or not to include links back to GitHub}

\item{hover}{Boolean whether or not tasks should be animated to slightly enlarge on hover}

\item{colors}{Character vector of hex colors for not started, in progress, and complete tasks (respectively)}
}
\value{
Returns character string of HTML/CSS with class attribute to be correctly shown "as-is" in RMarkdown
}
\description{
Produces three column task board showing any relevant objects (typically issues or milestones)
as "Not Started", "In Progress", or "Done".
}
\details{
The following logic is used to determine the status of each issue:
\itemize{
  \item Done: Items with a \code{state} of "closed"
  \item In Progress: Custom logic via \code{in_progress_when}. See \code{?taskboard_helpers} for details.
  \item Not Started: Default case for items neither In Progress or Closed
}
}
\examples{
\dontrun{
# in RMarkdown
```{r}
issues <- get_issues(myrepo, milestone = 1)
issues_df <- parse_issues(issues)
report_taskboard(issues_df, in_progress_when = is_labeled_with('in-progress'))
````
}
}
