% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_issues}
\alias{get_issues}
\title{Get issues from GitHub repository}
\usage{
get_issues(ref, limit = 1000, ...)
}
\arguments{
\item{ref}{Repository reference (list) created by \code{create_repo_ref()}}

\item{limit}{Number of records to return, passed directly to \code{gh} documentation. Defaults to
1000 and provides message if number of records returned equals the limit}

\item{...}{Additional user-defined query parameters. Use \code{browse_docs()} to learn more.}
}
\value{
Content of GET request as list
}
\description{
A single issue can be obtained by identification number of \code{number} is passed through \code{...}s.
In this case, all other query parameters will be ignored.
}
\examples{
\dontrun{
myrepo <- create_repo_ref('emilyriederer', 'myrepo')
issues_res <- get_issues(myrepo)
issues <- parse_issues(issues_res)
}
}
\seealso{
Other issues: \code{\link{get_issue_comments}},
  \code{\link{get_issue_events}},
  \code{\link{parse_issue_comments}},
  \code{\link{parse_issue_events}},
  \code{\link{parse_issues}}, \code{\link{post_issue}},
  \code{\link{report_discussion}},
  \code{\link{report_progress}},
  \code{\link{viz_waterfall}}
}
\concept{issues}
