% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup_projects}
\alias{setup_projects}
\title{Set up the projects folder}
\usage{
setup_projects(
  path,
  folder_name = "projects",
  overwrite = FALSE,
  make_directories = FALSE,
  .Renviron_path = file.path(Sys.getenv("HOME"), ".Renviron")
)
}
\arguments{
\item{path}{The file path of the \strong{directory inside of which} the user
would like the projects folder to be created. Do not include the name of
the projects folder itself (i.e., the value of the argument
\code{folder_name} below).}

\item{folder_name}{The name of the projects folder that will be created in
the directory specified by the argument \code{path} above. Defaults to
\code{"projects"}.}

\item{overwrite}{Logical indicating whether or not to abandon any previously
stored projects folders stored in the system.}

\item{make_directories}{Logical indicating whether or not the function should
write any directories specified in the \code{path} argument that don't
already exist.}

\item{.Renviron_path}{The full file path of the .Renviron file where the user
would like to store the \code{\link{projects_folder}()} path. Default is
the home .Renviron file. If the file doesn't exist it will be created.}
}
\value{
The project folder's path, invisibly.
}
\description{
Creates or restores the projects folder at the user-specified path.
}
\details{
The \code{\link[=projects-package]{projects}} package remembers where the
\link[=projects_folder]{projects folder} is located by storing its file path
in a \link{.Renviron} file (the home .Renviron file by default). The entry is
named \code{PROJECTS_FOLDER_PATH}.

Note that changing the \code{.Renviron_path} argument may create an .Renviron
file that R will not notice or use. See \link{Startup} for more details.
}
\section{Default contents}{
 The \link[=projects_folder]{projects folder}
  automatically contains the subdirectories \emph{.metadata} and
  \emph{.templates}, which are hidden by default on some operating systems.

  The \emph{.metadata} folder and its contents should \strong{never} be
  manually moved or modified.

  The \emph{.templates} folder is where template project files and folders
  should be stored. When this function is successfully run, the default
  projects folder template is created (as "default_folder") alongside a few
  other template files. When a new project is created,
  \code{\link{new_project}()} looks here for the folder named by its
  \code{template_folder} argument (\code{"default_folder"} by default), and
  this folder is copied into the \link[=projects_folder]{projects folder}
  (with name specified by the \code{folder_name} argument) as the new project
  folder. Users are able and encouraged to customize the
  \code{default_folder} to suit their research needs, and may even create
  multiple project folder templates for different situations.

  The default templates are in the folder located at the path produced by
  running: \code{\link{system.file}("templates", package = "projects")}
}

\section{Behavior when projects folder already exists}{
 If \code{overwrite =
  TRUE}, the function will run no matter what. Use with caution.

  If the user has a pre-existing \link[=projects_folder]{projects folder} and
  runs this command with the pre-existing projects folder's path, nothing
  will be deleted.

  \strong{Therefore}, if the user "broke" the projects folder (e.g., by
  deleting metadata; by changing the "PROJECTS_FOLDER_PATH" line in the
  \emph{.Renviron} file), the user can "fix" the projects folder to some
  degree by running this function with the folder's actual file path (e.g.,
  restore all default templates; restore missing metadata files).
}

\examples{
#############################################################################
# Setup
# Any existing "projects" folder is left totally untouched,
# and the user's home directory and .Renviron file are also left untouched.
old_home  <- Sys.getenv("HOME")
old_ppath <- Sys.getenv("PROJECTS_FOLDER_PATH")
temp_dir <- tempfile("dir")
dir.create(temp_dir)
Sys.setenv(HOME = temp_dir)
Sys.unsetenv("PROJECTS_FOLDER_PATH")
#############################################################################

# Creating the projects folder
setup_projects(path = temp_dir)

# Viewing the projects folder path:
path1 <- projects_folder()

# Viewing the contents of the projects folder:
list.files(path1, full.names = TRUE, recursive = TRUE,  all.files = TRUE)

# Create an arbitrary subfolder in temp_dir:
subfolder_path <- file.path(temp_dir, "test")
dir.create(subfolder_path)


# Wrapped in if (interactive()) because it requires user input
if (interactive()) {
  # The function won't let the user abandon the old projects folder...
  setup_projects(path = subfolder_path)

  # ...unless overwrite = TRUE
  setup_projects(path = file.path(temp_dir, "test"), overwrite = TRUE)

  # Even then, only the stored location of the projects folder is overwritten.
  # The old projects folder still exists:
  list.files(path1, full.names = TRUE, recursive = TRUE,  all.files = TRUE)

  # Giving the "projects" folder a different name:
  setup_projects(path = temp_dir, folder_name = "studies", overwrite = TRUE)
}

#############################################################################
# Cleanup
# (or, the user can just restart R)
Sys.setenv(HOME = old_home, PROJECTS_FOLDER_PATH = old_ppath)
#############################################################################
}
\seealso{
\code{\link{new_project}()} for information on templates

  \link{Startup} for more information on how \emph{.Renviron} files work.
}
