% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splines.R
\name{make_basis_mats}
\alias{make_basis_mats}
\title{Create a List of Basis Matrices}
\usage{
make_basis_mats(
  x,
  n = length(x),
  mu = 0.5,
  sigma = 1,
  nonc = 0,
  tailw = 1,
  deg = 1,
  periodic = FALSE,
  idx = NULL,
  params = NULL
)
}
\arguments{
\item{x}{The predictor variable}

\item{n}{Number of knots}

\item{mu}{Beta distribution location parameter}

\item{sigma}{Beta distribution scale parameter}

\item{nonc}{Beta distribution noncentrality parameter}

\item{tailw}{Tailweight}

\item{deg}{Degree of splines}

\item{periodic}{Create periodic basis}

\item{idx}{\code{make_basis_mats()} will create a grid containing all
combinations of the parameters. If idx is set, this grid will
be subsetted to the rows specified by idx.}

\item{params}{Instead of the arguments above, a grid (data.frame
or named matrix) of parameters can be passed directly.}
}
\description{
This function creates a list of basis matrices and the corresponding
parameters. It is used in \code{online()} to create the basis matrices
for basis smoothing.
}
