% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rprof-read.R, R/pprof-read.R, R/rprof-write.R,
%   R/pprof-write.R
\name{read_rprof}
\alias{read_rprof}
\alias{read_pprof}
\alias{write_rprof}
\alias{write_pprof}
\title{File I/O for profiler data}
\usage{
read_rprof(path, ..., version = "1.0")

read_pprof(path, ..., version = "1.0")

write_rprof(x, path)

write_pprof(x, path)
}
\arguments{
\item{path}{File name}

\item{...}{Ignored}

\item{version}{Version of the data, currently only \code{"1.0"} is supported.
Pass an explicit value to this argument if your code depends on the data
format.}

\item{x}{Profiler data, see \code{\link[=validate_profile]{validate_profile()}}}
}
\value{
Valid profile data (readers), input data (writers).
}
\description{
These functions read profile data from files, or store profile data to files.
Readers call \code{\link[=validate_profile]{validate_profile()}} on input, writers on output.

\code{read_rprof()} reads a file generated by \code{\link[=Rprof]{Rprof()}}, \code{write_rprof()} writes
in a compatible format.

\code{read_pprof()} reads a file generated by \code{pprof -proto}, \code{write_pprof()}
writes a Gzip-compressed file that can be processed with \code{pprof}.
}
\details{
Use the \pkg{proftools}, \pkg{profvis}, or \pkg{prof.tree} R packages to
further analyze files created by the \code{write_rprof()} function.

Use the \href{https://github.com/google/pprof}{pprof tool} in conjunction with
the \code{_pprof()} functions. The tool is available in the \pkg{pprof} R package,
or (in newer versions) via \code{go get github.com/google/pprof}.
}
\examples{
rprof_file <- system.file("samples/rprof/1.out", package = "profile")
ds <- read_rprof(rprof_file)
ds
if (requireNamespace("RProtoBuf", quietly = TRUE)) {
  pprof_file <- tempfile("profile", fileext = ".pb.gz")
  write_pprof(ds, pprof_file)
}
}
