\name{predictSurvIndividual}
\alias{predictSurvIndividual}
\title{Predict individual survival probabilities}
\usage{
predictSurvIndividual(object, lag = 1)
}
\arguments{
  \item{object}{A fitted object of class "prodlim".}

  \item{lag}{Integer. `0' means predictions at the
  individual times, 1 means just before the individual
  times, etc.}
}
\value{
A vector of survival probabilities.
}
\description{
Function to extract the predicted probabilities at the
individual event times that have been used for fitting a
prodlim object.
}
\examples{
SurvFrame <- data.frame(time=1:10,status=rbinom(10,1,.5))
 x <- prodlim(formula=Hist(time=time,status!=0)~1,data=SurvFrame)
 predictSurvIndividual(x,lag=1)
}
\author{
Thomas A. Gerds \email{tag@biostat.ku.dk}
}
\seealso{
\code{\link{predict.prodlim}},\code{\link{predictSurv}},
}
\keyword{survival}

