% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotted_char_plotly_i.R, R/dotted_chart.R
\name{idotted_chart}
\alias{idotted_chart}
\alias{iplotly_dotted_chart}
\alias{plotly_dotted_chart}
\alias{dotted_chart}
\alias{dotted_chart.eventlog}
\alias{dotted_chart.activitylog}
\alias{dotted_chart.grouped_eventlog}
\alias{dotted_chart.grouped_activitylog}
\title{Dotted chart}
\usage{
idotted_chart(eventlog, plotly = FALSE)

iplotly_dotted_chart(eventlog)

plotly_dotted_chart(
  eventlog,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = c("start", "end", "duration", "start_week", "start_day"),
  color = NULL,
  units = c("weeks", "days", "hours", "mins", "secs"),
  ...
)

dotted_chart(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = NULL,
  color = NULL,
  units = NULL,
  add_end_events = F,
  eventlog = deprecated(),
  ...
)

\method{dotted_chart}{eventlog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = NULL,
  color = NULL,
  units = NULL,
  add_end_events = F,
  eventlog = deprecated(),
  ...
)

\method{dotted_chart}{activitylog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = NULL,
  color = NULL,
  units = NULL,
  add_end_events = F,
  eventlog = deprecated(),
  ...
)

\method{dotted_chart}{grouped_eventlog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = NULL,
  color = NULL,
  units = NULL,
  add_end_events = F,
  eventlog = deprecated(),
  ...
)

\method{dotted_chart}{grouped_activitylog}(
  log,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = NULL,
  color = NULL,
  units = NULL,
  add_end_events = F,
  eventlog = deprecated(),
  ...
)
}
\arguments{
\item{eventlog}{Deprecated. Use log instead.}

\item{plotly}{Return plotly object}

\item{x}{Value for plot on x-axis: absolute time or relative time (since start, since start of week, since start of day)}

\item{sort}{Ordering of the cases on y-axis: start, end or duration, start_week, start_day}

\item{color}{Optional, variable to use for coloring dots. Default is the activity identifier. Use NA for no colors.}

\item{units}{Time units to use on x-axis in case of relative time.}

\item{...}{Deprecated arguments}

\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{add_end_events}{Whether to add dots for the complete lifecycle event with a different shape.}
}
\description{
Create a dotted chart to view all events in a glance
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Create dotted chart for eventlog

\item \code{activitylog}: Create dotted chart for activitylog

\item \code{grouped_eventlog}: Create dotted chart for grouped eventlog

\item \code{grouped_activitylog}: Create dotted chart for grouped activitylog
}}

