% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcRules.R
\name{six_sigma_ctrl_chart}
\alias{six_sigma_ctrl_chart}
\title{Generate IndX and mR charts.}
\usage{
six_sigma_ctrl_chart(x, linesColors = c("gray50", "gray65", "gray85", "black",
  "gray85", "gray65", "gray50"), applyRules = c(TRUE, TRUE, TRUE, TRUE, TRUE,
  TRUE, TRUE, TRUE), rulesColors = c("red", "yellow2", "green", "magenta",
  "blue", "orange", "brown", "cyan"), seg = c(), keepStats = TRUE,
  verbose = FALSE)
}
\arguments{
\item{x}{(mandatory) A data frame with the individual values in the first column and the time in the second column. It can be either a factor, a date or a string and it will be ordered automatically. \cr See \code{?spcTimeSeries}}

\item{linesColors}{(optional) A vector with 7 colors in order from the average + 3 standard deviations to the average - 3 standard deviations, including the average itself in the center. \cr Default value is \code{c("gray50", "gray65", "gray85", "black", "gray85", "gray65", "gray50")}}

\item{applyRules}{(optional) A vector with 8 boolean values indicating which rules must be applied. \cr Default value is \code{c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE)}}

\item{rulesColors}{(optional) A vector with colors, one for each rule. The last point of each violating run will be colored indicating the violation and the corresponding rule. \cr Default value is \code{c("red", "yellow2", "green", "magenta", "blue", "orange", "brown", "cyan")}}

\item{seg}{(optional) A vector with the positions of the points where there should be breaks and another pair of charts should be plotted. It may be used for better visualization when the series is too long. \cr Default value is \code{c()}}

\item{keepStats}{(optional) A boolean indicating if each segment's plot should be considered as part of the same series or independelty, as different series. If TRUE, it will be considered as part of the same series. If FALSE, each plot will have it's limits calculated independently, as well as the application of the rules. It's useful to compare different scenarios. \cr Default value is \code{TRUE}}

\item{verbose}{(optional) A boolean indicating if mean, standard deviation/UCL and number of violations should be printed. \cr Default value is \code{FALSE}}
}
\value{
None
}
\description{
Generate IndX and mR charts.
}
\examples{
data("spcTimeSeries")
six_sigma_ctrl_chart(spcTimeSeries)
six_sigma_ctrl_chart(spcTimeSeries, verbose=TRUE)
six_sigma_ctrl_chart(spcTimeSeries, seg=c(25, 50, 75))
six_sigma_ctrl_chart(spcTimeSeries, seg=c(25, 50, 75), keepStats=FALSE, verbose=TRUE)
}
\references{
Engineering Statistics Handbook 6.3.2, NIST/SEMATECH e-Handbook of Statistical Methods National Institute of Standards and Technology, Dec 2006

https://en.wikipedia.org/wiki/Nelson_rules

Lloyd S. Nelson, "Technical Aids," Journal of Quality Technology 16, no. 4 (October 1984), 238-239.

The 8 rules are:
1 One point is more than 3 standard deviations from the mean.
2 Nine (or more) points in a row are on the same side of the mean.
3 Six (or more) points in a row are continually increasing (or decreasing).
4 Fourteen (or more) points in a row alternate in direction, increasing then decreasing.
5 Two (or three) out of three points in a row are more than 2 standard deviations from the mean in the same direction.
6 Four (or five) out of five points in a row are more than 1 standard deviation from the mean in the same direction.
7 Fifteen points in a row are all within 1 standard deviation of the mean on either side of the mean.
8 Eight points in a row exist with none within 1 standard deviation of the mean and the points are in both directions from the mean.
}

