% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rules.R
\name{check_rules}
\alias{check_rules}
\title{Check multiple declarative rules.}
\usage{
check_rules(eventlog, ...)
}
\arguments{
\item{eventlog}{Eventlog object}

\item{...}{Name-rule pairs.}
}
\value{
An annotated event log, where - for every rule - a new column indicates whether the rule holds or not.
The name of each rule becomes the name of the column.
}
\description{
This function can be used to check several rules on event data. It needs an event log and a rule. Rules can be made with the following functions:
absent(),
and(),
contains(),
contains_between(),
contains_exactly(),
ends(),
precedence(),
response(),
responded_existence(),
starts(),
succession(),
xor().
}
\examples{

library(eventdataR)

# check whether MRI Scan is preceded by Blood test, and the case starts with Registration
check_rules(patients,
            rule1 = precedence("Blood test","MRI SCAN"),
            rule2 = starts("Registration"))

}
