% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condPlot.R
\name{condPlot}
\alias{condPlot}
\title{Draw conditional effect plot}
\usage{
condPlot(
  fit,
  xmode = 1,
  pred = NULL,
  modx = NULL,
  pred.values = NULL,
  modx.values = NULL,
  labels = NULL,
  mode = 1,
  rangemode = 1,
  ypos = NULL,
  hjust = NULL,
  linecolor = "gray60",
  linetype = 2,
  linesize = 1,
  arrowsize = 1,
  digits = 3,
  depM = FALSE,
  ...
)
}
\arguments{
\item{fit}{An object of class lm}

\item{xmode}{integer. 1 or 2.}

\item{pred}{name of predictor variable}

\item{modx}{name of moderator variable}

\item{pred.values}{Values of predictor variables}

\item{modx.values}{Values of modifier variables}

\item{labels}{labels of regression lines}

\item{mode}{integer. one of 1:3.}

\item{rangemode}{integer. 1 or 2}

\item{ypos}{integer. label y position.}

\item{hjust}{hjust of label}

\item{linecolor}{name of color of vline and hline}

\item{linetype}{linetype of arrow}

\item{linesize}{size of regression line}

\item{arrowsize}{size of arrow}

\item{digits}{integer indicating the number of decimal places}

\item{depM}{logical If true, label M instead of X}

\item{...}{further arguments to be passed to add_lines}
}
\description{
Draw conditional effect plot
}
\examples{
fit=lm(justify~frame*skeptic,data=disaster)
condPlot(fit,rangemode=2,xpos=0.7,labels=c("Climate change(X=1)","Natural causes(X=0)"))
\donttest{
condPlot(fit,mode=2,xpos=0.6)
condPlot(fit,mode=3,rangemode=2,xpos=0.5)
condPlot(fit,xmode=2)
condPlot(fit,xmode=2,mode=2)
condPlot(fit,xmode=2,mode=3)
fit=lm(mpg~vs*hp,data=mtcars)
condPlot(fit,rangemode=2,xpos=0.6)
condPlot(fit,mode=2,xpos=0.5)
condPlot(fit,mode=3,rangemode=2)
fit=lm(govact~negemot*age+posemot+ideology+sex,data=glbwarm)
condPlot(fit,xmode=2,hjust=c(-0.1,-0.1,1.1))
condPlot(fit,xmode=2,pred.values=c(30,70),hjust=c(-0.1,-0.1,1.1),xpos=0.5)
condPlot(fit,xmode=2,mode=2,pred.values=c(30,50,70),xpos=0.2)
condPlot(fit,xmode=2,mode=3,xpos=0.5,hjust=c(-0.1,-0.1,1.1))
condPlot(fit,xmode=2,modx.values=c(2,3,4),mode=3,xpos=0.6)
}
}
