% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCatEquation.R
\name{makeCatEquation3}
\alias{makeCatEquation3}
\title{Make equation for sem and lm for multiple X or multiple Y}
\usage{
makeCatEquation3(
  X = NULL,
  Y = NULL,
  W = NULL,
  labels = list(),
  prefix = "b",
  mode = 0,
  pos = list(),
  bmatrix = NULL,
  vars = list(),
  moderator = list(),
  depy = FALSE,
  depx = FALSE,
  interactionNo = 0
)
}
\arguments{
\item{X}{Names of independent variable}

\item{Y}{Names of dependent variable}

\item{W}{Names of moderators}

\item{labels}{optional list}

\item{prefix}{a character}

\item{mode}{A numeric}

\item{pos}{Numeric moderator position}

\item{bmatrix}{integer specifying causal relations among mediators}

\item{vars}{A list of triple moderator}

\item{moderator}{A list}

\item{depy}{logical}

\item{depx}{logical}

\item{interactionNo}{numeric}
}
\description{
Make equation for sem and lm for multiple X or multiple Y
}
\examples{
cat(makeCatEquation3(X="X",Y=c("M1","M2","M3"),prefix="a",bmatrix=c(1,1,0,1,0,0,1,1,1,1)))
cat(makeCatEquation3(X="X",Y=c("M1","M2","M3"),prefix="a",bmatrix=c(1,1,0,1,0,1,1,1,1,1)))
cat(makeCatEquation3(X="X",Y=c("M1","M2","M3"),prefix="a",bmatrix=c(1,1,0,1,1,0,1,1,1,1)))
cat(makeCatEquation3(X="X",Y=c("M1","M2","M3"),prefix="a",bmatrix=c(1,1,1,1,1,1,1,1,1,1)))
cat(makeCatEquation3(X=c("M1","M2","M3"),Y="Y",prefix="a",bmatrix=c(1,1,1,1,1,1,1,1,1,1),depy=TRUE))
cat(makeCatEquation3(X="X",Y="Y",prefix="a",bmatrix=c(1,1,1,1,1,1,1,1,1,1),depy=TRUE,depx=TRUE))
cat(makeCatEquation3(X="X",Y="Y",prefix="a",bmatrix=c(1,1,1,1,1,1,0,1,1,1),depy=TRUE,depx=TRUE))
cat(makeCatEquation3(X=c("M1","M2"),Y="Y",prefix="a",bmatrix=c(1,1,1,1,0,1),depy=TRUE))
cat(makeCatEquation3(X=c("M1","M2"),Y="Y",prefix="a",bmatrix=c(1,1,1,1,1,0),depy=TRUE))
cat(makeCatEquation3(X="X",Y=c("M1","M2"),prefix="a",bmatrix=c(1,1,1,0,0,1),depy=FALSE))
cat(makeCatEquation3(X="X",Y=c("M1","M2"),W="W",prefix="a",bmatrix=c(1,1,1,1,1,1),depy=FALSE,
  moderator=list(name="W",matrix=list(c(0,0,1,0,0,0)))))
cat(makeCatEquation3(X=c("M1","M2"),Y="Y",prefix="a",bmatrix=c(1,1,1,1,0,1),depy=TRUE))
cat(makeCatEquation3(X=c("M1","M2"),Y="Y",W="W",pos=list(c(1,2)),prefix="a",
  bmatrix=c(1,1,1,1,0,1),depy=TRUE))
cat(makeCatEquation3(X=c("M1","M2"),Y="Y",W="W",
  moderator=list(name="W",matrix=list(c(0,0,0,0,1,1))),bmatrix=c(1,1,1,1,1,1),depy=TRUE))
vars=list(name=list(c("W","Z")),matrix=list(c(0,0,1,0,0,0)))
cat(makeCatEquation3(X="X",Y=c("M1","M2"),bmatrix=c(1,1,1,1,1,0),vars=vars,depy=FALSE,depx=TRUE))
}
