% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-estimate-isotonic.R
\name{cal_estimate_isotonic}
\alias{cal_estimate_isotonic}
\alias{cal_estimate_isotonic.data.frame}
\alias{cal_estimate_isotonic.tune_results}
\alias{cal_estimate_isotonic.grouped_df}
\title{Uses an Isotonic regression model to calibrate model predictions.}
\usage{
cal_estimate_isotonic(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  parameters = NULL,
  ...
)

\method{cal_estimate_isotonic}{data.frame}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  parameters = NULL,
  ...,
  .by = NULL
)

\method{cal_estimate_isotonic}{tune_results}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  parameters = NULL,
  ...
)

\method{cal_estimate_isotonic}{grouped_df}(
  .data,
  truth = NULL,
  estimate = NULL,
  parameters = NULL,
  ...
)
}
\arguments{
\item{.data}{An ungrouped \code{data.frame} object, or \code{tune_results} object,
that contains predictions and probability columns.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{parameters}{(Optional)  An optional tibble of tuning parameter values
that can be used to filter the predicted values before processing. Applies
only to \code{tune_results} objects.}

\item{...}{Additional arguments passed to the models or routines used to
calculate the new probabilities.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}
}
\description{
Uses an Isotonic regression model to calibrate model predictions.
}
\details{
This function uses \code{\link[stats:isoreg]{stats::isoreg()}} to create obtain the calibration
values for binary classification or numeric regression.
}
\section{Multiclass Extension}{


This method is designed to work with two classes. For multiclass, it creates
a set of "one versus all" calibrations for each class. After they are
applied to the data, the probability estimates are re-normalized to add to
one. This final step might compromise the calibration.
}

\examples{
# ------------------------------------------------------------------------------
# Binary Classification

# It will automatically identify the probability columns
# if passed a model fitted with tidymodels
cal_estimate_isotonic(segment_logistic, Class)

# Specify the variable names in a vector of unquoted names
cal_estimate_isotonic(segment_logistic, Class, c(.pred_poor, .pred_good))

# dplyr selector functions are also supported
cal_estimate_isotonic(segment_logistic, Class, dplyr::starts_with(".pred_"))

# ------------------------------------------------------------------------------
# Regression (numeric outcomes)

cal_estimate_isotonic(boosting_predictions_oob, outcome, .pred)
}
\references{
Zadrozny, Bianca and Elkan, Charles. (2002). Transforming Classifier Scores
into Accurate Multiclass Probability Estimates. \emph{Proceedings of the ACM SIGKDD
International Conference on Knowledge Discovery and Data Mining.}
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_validate_isotonic]{cal_validate_isotonic()}}
}
