% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymize_dates.R
\name{anonymize_dates}
\alias{anonymize_dates}
\title{Anonymize Dates}
\usage{
anonymize_dates(
  x,
  method = c("shift", "round"),
  days_shift = NULL,
  granularity = "month",
  seed = NULL
)
}
\arguments{
\item{x}{A vector of dates (Date, POSIXct, or character that can be coerced to Date)}

\item{method}{Character string specifying anonymization method:
"shift" (default) shifts all dates by a random offset,
"round" rounds dates to specified granularity}

\item{days_shift}{For "shift" method: number of days to shift (default: random between -365 and 365)}

\item{granularity}{For "round" method: "day", "week", "month", "month_year", "quarter", or "year" (default: "month").
"month_year" returns character strings in "YYYYMM" format (e.g., "202005" for May 2020).}

\item{seed}{An optional seed for reproducible anonymization}
}
\value{
A Date vector of anonymized dates (or character vector for "month_year" granularity)
}
\description{
Anonymizes dates by shifting them by a random offset or rounding to a
specified granularity. Shifting preserves relative time differences.
}
\examples{
dates <- as.Date(c("2020-01-15", "2020-03-20", "2020-06-10"))
anonymize_dates(dates, method = "shift", seed = 123)
anonymize_dates(dates, method = "round", granularity = "month")
anonymize_dates(dates, method = "round", granularity = "month_year")

}
