% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerscale_gradients.R
\name{powerscale-gradients}
\alias{powerscale-gradients}
\alias{powerscale_gradients}
\alias{powerscale_gradients.default}
\alias{powerscale_gradients.priorsense_data}
\title{Power-scale gradients}
\usage{
powerscale_gradients(x, ...)

\method{powerscale_gradients}{default}(x, ...)

\method{powerscale_gradients}{priorsense_data}(
  x,
  variable = NULL,
  component = c("prior", "likelihood"),
  type = c("quantities", "divergence"),
  lower_alpha = 0.99,
  upper_alpha = 1.01,
  div_measure = "cjs_dist",
  measure_args = list(),
  moment_match = FALSE,
  k_threshold = 0.5,
  resample = FALSE,
  transform = NULL,
  prediction = NULL,
  scale = FALSE,
  prior_selection = NULL,
  likelihood_selection = NULL,
  ...
)
}
\arguments{
\item{x}{Model fit or draws object.}

\item{...}{Further arguments passed to functions.}

\item{variable}{Variables to compute sensitivity of. If NULL
(default) sensitivity is computed for all variables.}

\item{component}{Component to power-scale (prior or likelihood).}

\item{type}{type of sensitivity to measure ("distance",
"quantity").  Multiple options can be specified at the same
time.}

\item{lower_alpha}{lower power to scale component by, should be <
1 (default is 0.9).}

\item{upper_alpha}{upper power to scale component by, should be >
1 (default is 1.1).}

\item{div_measure}{The divergence measure to use. The
following methods are implemented:
\itemize{
\item \code{"cjs_dist"}: Cumulative Jensen-Shannon distance. Default
method. See function \code{cjs_dist} for more details.
\item \code{"js_dist"}: Jensen-Shannon distance.
\item \code{"js_div"}: Jensen-Shannon divergence.
\item \code{"hellinger_dist"}: Hellinger distance.
\item \code{"kl_dist"}: Kullback-Leibler distance.
\item \code{"kl_div"}: Kullback-Leibler divergence.
\item \code{"ks_dist"}: Kolmogorov-Smirnov distance.
\item \code{"hellinger_dist"}: Hellinger distance.
\item \code{"ws_dist"}: Wassterstein distance (pass \code{measure_args = list(p = N)})
for a different order, where N is the order.
}}

\item{measure_args}{Named list of further arguments passed to divergence measure functions.}

\item{moment_match}{Logical; Indicate whether or not moment
matching should be performed. Can only be TRUE if \code{is_method} is
"psis".}

\item{k_threshold}{Threshold value for Pareto k values above which
the moment matching algorithm is used. Default is 0.5.}

\item{resample}{Logical; Indicate whether or not draws should be
resampled based on calculated importance weights.}

\item{transform}{Indicate a transformation of posterior draws to
perform before sensitivity analysis. Either "scale" or "whiten".}

\item{prediction}{Function taking the model fit and returning a
draws_df of predictions to be appended to the posterior draws}

\item{scale}{logical scale quantity gradients by base posterior
standard deviation.}

\item{prior_selection}{Numeric vector specifying which priors to
consider.}

\item{likelihood_selection}{Numeric vector specifying which likelihoods to
consider.}
}
\value{
Maximum of the absolute derivatives above and below alpha
= 1.
}
\description{
Calculate the numerical derivative of posterior
quantities/divergence with respect to power-scaling the specified
component (prior or likelihood). This is done using importance
sampling (and optionally moment matching).
}
\examples{
ex <- example_powerscale_model()
drw <- ex$draws

powerscale_gradients(drw)
}
