% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_grid.r
\name{make_grid}
\alias{make_grid}
\alias{make_grid.Raster}
\alias{make_grid.Spatial}
\title{Create square or hexagonal grids}
\usage{
make_grid(x, type = c("hexagonal", "square"), cell_width, cell_area, clip)

\method{make_grid}{Raster}(x, type = c("hexagonal", "square"), cell_width,
  cell_area = prod(raster::res(x)), clip = FALSE)

\method{make_grid}{Spatial}(x, type = c("hexagonal", "square"), cell_width,
  cell_area, clip = FALSE)
}
\arguments{
\item{x}{Raster* or Spatial* object; the region over which to define the
study grid.}

\item{type}{"square" or "hexagonal"; type of grid.}

\item{cell_width}{numeric; distance between cell centers.}

\item{cell_area}{numeric; area of cell, only used if \code{cell_width} is
missing. This defaults to the resolution of the argument \code{x} if
it is a \code{\link[raster]{RasterLayer-class}} object.}

\item{clip}{logical; whether or not to clip the cells to the study area
boundary.}
}
\value{
SpatialPolygons object
}
\description{
Generate regular square or hexagonal spatial grids based on a Raster* or
Spatial* object defining a study area. Grids can be specified by width (i.e.
distance between cell centres) or area, and cells at the edge of the study
area can be optionally clipped to the study area boundary.
}
\section{Methods (by class)}{
\itemize{
\item \code{Raster}: RasterLayer input

\item \code{Spatial}: Spatial* input
}}
\examples{
r <- raster::raster(matrix(1:9, 3, 3))
sq_grid <- make_grid(r, type = "square")
raster::plot(r)
hex_grid <- make_grid(sq_grid[9,], cell_width = 0.1, type = "hexagonal", clip=TRUE)
sp::plot(sq_grid, add = TRUE)
sp::plot(hex_grid, add = TRUE, border = "red", lwd = 2)
}

