% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio-class.R
\name{portfolio-class}
\alias{portfolio-class}
\alias{Portfolio}
\title{Portfolio class}
\value{
No return value.
}
\description{
This class encodes for the solutions obtained when solving
multiple instances. This includes several methods
to obtain information about both the optimization process and the solution associated with
the planning units and conservation actions. It is created using the \emph{eval} functions
(e.g. \code{evalTarget()} or \code{evalBudget()}).
}
\section{Fields}{

\describe{
\item{$data}{
\code{list}. Object containing data on the results of the optimization process.}
}
}

\section{Methods}{

\describe{
\item{getNames()}{
\code{character}. Label indicating the name of solutions.}

\item{print()}{
Print basic information of the model solution.}

\item{show()}{
Call print method.}
}
}

\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Create model and solve
port <- evalBlm(pu = sim_pu_data, features = sim_features_data,
                dist_features = sim_dist_features_data,
                threats = sim_threats_data,
                dist_threats = sim_dist_threats_data,
                sensitivity = sim_sensitivity_data,
                boundary = sim_boundary_data,
                values = c(0.0, 0.01, 0.02, 0.03),
                model_type = "minimizeCosts",
                time_limit = 50,
                output_file = FALSE, cores = 2)

## Use class methods
port$getNames()

port$print()
}
}
