# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Sliding window to create chunks of DNA sequences
#'
#' @title chunker
#' @description Creates all primer candidates for a group of sequences using a
#'              sliding window.
#' @param seq_table A DataFrame containing a column for sequence ids (Id) and
#'        sequences (Seq).
#' @param window_size An integer. Set the sliding window width.
#' @return A DataFrame containing columns for the sequence ids (Id),
#'         indexes (Ix), joined ids and indexes (Id_Ix), and the primer
#'         sequences (Seq).
#'
#' @examples
#'
#' test_csv <- system.file("extdata", "test.csv", package = "prider")
#'
#' test_csv <- read.csv(test_csv)
#'
#' chunks <- chunker(test_csv)
#'
#' @export
chunker <- function(seq_table, window_size = 20L) {
    .Call('_prider_chunker', PACKAGE = 'prider', seq_table, window_size)
}

