pkgname <- "prevR"
source(file.path(R.home("share"), "R", "examples-header.R"))
options(warn = 1)
options(pager = "console")
library('prevR')

base::assign(".oldSearch", base::search(), pos = 'CheckExEnv')
cleanEx()
nameEx("TMWorldBorders")
### * TMWorldBorders

flush(stderr()); flush(stdout())

### Name: TMWorldBorders
### Title: Dataset "TM World Borders Dataset 0.3".
### Aliases: TMWorldBorders
### Keywords: datasets spatial

### ** Examples

plot(TMWorldBorders)



cleanEx()
nameEx("as.SpatialGrid-prevR-method")
### * as.SpatialGrid-prevR-method

flush(stderr()); flush(stdout())

### Name: as.SpatialGrid,prevR-method
### Title: Create a spatial grid from an object of class prevR.
### Aliases: as.SpatialGrid as.SpatialGrid-methods
###   as.SpatialGrid,prevR-method
### Keywords: manip spatial

### ** Examples

str(as.SpatialGrid(fdhs))
str(as.SpatialGrid(fdhs, nb.cells=200))



cleanEx()
nameEx("as.data.frame.prevR")
### * as.data.frame.prevR

flush(stderr()); flush(stdout())

### Name: as.data.frame.prevR
### Title: Convert an object of class prevR into a data.frame.
### Aliases: as.data.frame.prevR as.data.frame
### Keywords: manip

### ** Examples

str(fdhs)
str(as.data.frame(fdhs))
## Not run: 
##D 	r.fdhs <- rings(fdhs, N=c(100,200,300))
##D 	str(r.fdhs)
##D 	str(as.data.frame(r.fdhs, clusters.only=TRUE))
##D 	str(as.data.frame(r.fdhs))
##D 	str(as.data.frame(r.fdhs, N=300))
## End(Not run)



cleanEx()
nameEx("as.prevR")
### * as.prevR

flush(stderr()); flush(stdout())

### Name: as.prevR
### Title: Create an object of class prevR.
### Aliases: as.prevR
### Keywords: manip

### ** Examples

## Not run: 
##D col <- c(id = "cluster",
##D          x = "x",
##D          y = "y",
##D          n = "n",
##D          pos = "pos",
##D          c.type = "residence",
##D          wn = "weighted.n",
##D          wpos = "weighted.pos"
##D         )
##D dhs <- as.prevR(fdhs.clusters,col, fdhs.boundary)
##D 
##D str(dhs)
##D print(dhs)
## End(Not run)



cleanEx()
nameEx("changeproj-prevR-method")
### * changeproj-prevR-method

flush(stderr()); flush(stdout())

### Name: changeproj,prevR-method
### Title: Convert map projection of a object of class prevR.
### Aliases: changeproj,prevR-method changeproj changeproj-methods
### Keywords: manip spatial

### ** Examples

print(fdhs)
plot(fdhs, axes=TRUE, main="Projection: longitude/latitude")

fdhs2 <- changeproj(fdhs,
         "+proj=utm +zone=30 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
print(fdhs2)
dev.new()
plot(fdhs2, axes=TRUE, main="Projection: UTM Zone 30")



cleanEx()
nameEx("create.boundary")
### * create.boundary

flush(stderr()); flush(stdout())

### Name: create.boundary
### Title: Provide national boundaries of a country.
### Aliases: create.boundary
### Keywords: manip spatial

### ** Examples

## Not run: 
##D boundary <- create.boundary()
## End(Not run)
## Don't show: 
par(ask = TRUE)
## End Don't show
boundary <- create.boundary("Burkina Faso")
boundary <- create.boundary("Burkina Faso",
            proj="+proj=utm +zone=30 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
boundary <- create.boundary(countries = c("Burkina Faso", "Ghana", "Benin"))
## Don't show: 
par(ask = FALSE)
## End Don't show



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
cleanEx()
nameEx("export-prevR-method")
### * export-prevR-method

flush(stderr()); flush(stdout())

### Name: export,prevR-method
### Title: Export an object of class prevR.
### Aliases: export-methods export,prevR-method export
### Keywords: manip spatial

### ** Examples

## Not run: 
##D export(fdhs, element="boundary", file="area")
##D export(fdhs, element="clusters", format="shp", file="points")
##D 
##D dhs <- rings(fdhs,N=c(100,300,500))
##D export(dhs, element="clusters", format="csv", N=300, file="points")
## End(Not run)


cleanEx()
nameEx("fdhs.prevR")
### * fdhs.prevR

flush(stderr()); flush(stdout())

### Name: fdhs
### Title: Fictitious data generated by a DHS simulation.
### Aliases: fdhs fdhs.boundary fdhs.clusters
### Keywords: datasets

### ** Examples

## Not run: 
##D str(fdhs)
##D str(fdhs.clusters)
##D str(fdhs.boundary)
##D demo(prevR)
## End(Not run)



cleanEx()
nameEx("import.dhs")
### * import.dhs

flush(stderr()); flush(stdout())

### Name: import.dhs
### Title: Import DHS data.
### Aliases: import.dhs
### Keywords: manip

### ** Examples

## Not run: 
##D import.dhs("data.sav", "gps.dbf")
## End(Not run)



cleanEx()
nameEx("is.prevR")
### * is.prevR

flush(stderr()); flush(stdout())

### Name: is.prevR
### Title: Test if an object is of class prevR.
### Aliases: is.prevR
### Keywords: classes

### ** Examples

col <- c(id = "cluster", 
         x = "x",
         y = "y",
         n = "n",
         pos = "pos",
         c.type = "residence",
         wn = "weighted.n",
         wpos = "weighted.pos"
        )
dhs <- as.prevR(fdhs.clusters,col, fdhs.boundary)

is.prevR(dhs)
is.prevR(dhs,"rings")
is.prevR(dhs,"boundary")

dhs <- rings(dhs,N=300)
is.prevR(dhs,"rings")



cleanEx()
nameEx("kde-prevR-method")
### * kde-prevR-method

flush(stderr()); flush(stdout())

### Name: kde,prevR-method
### Title: Kernel density estimation for prevR object.
### Aliases: kde-methods kde,prevR-method kde
### Keywords: smooth spatial

### ** Examples

## Not run: 
##D dhs <- rings(fdhs, N=c(100,200,300,400,500))
##D 
##D prev.N300 <- kde(dhs, N=300, nb.cells=200)
##D spplot(prev.N300, 'k.wprev.N300.RInf',
##D        cuts=100, col.regions=prevR.colors.red(101),
##D        main="Regional trends of prevalence (N=300)"
##D       )
##D 
##D prev.krige <- kde(dhs, N=c(100,300,500), R=Inf,
##D                   nb.cells=200, risk.ratio=2, keep.details=FALSE
##D                  )
##D str(prev.krige)
##D dev.new()
##D spplot(prev.krige,
##D        c('k.wprev.N100.RInf','k.wprev.N300.RInf','k.wprev.N500.RInf'),
##D        cuts=100, col.regions=prevR.colors.red(101)
##D       )
## End(Not run)



cleanEx()
nameEx("krige-prevR-method")
### * krige-prevR-method

flush(stderr()); flush(stdout())

### Name: krige,prevR-method
### Title: Spatial interpolation (kriging and inverse distance weighting)
###   for objects of class prevR.
### Aliases: krige,prevR-method krige-methods krige,ANY,prevR-method krige
###   idw-methods idw,ANY,prevR-method idw,prevR-method idw
### Keywords: smooth spatial

### ** Examples

## Not run: 
##D dhs <- rings(fdhs, N=c(100,200,300,400,500))
##D radius.N300 <- krige('r.radius', dhs, N=300, nb.cells=200)
##D spplot(radius.N300,
##D        cuts=100, col.regions=prevR.colors.blue(101), 
##D        main="Radius of circle (N=300)"
##D       )
##D 
##D 
##D prev.krige <- krige('r.wprev', dhs, N=c(100,300,500),R=Inf,
##D                     fit="manual",keep.variance=TRUE
##D                    )
##D str(prev.krige)
##D spplot(prev.krige,
##D        c('r.wprev.N100.RInf','r.wprev.N300.RInf','r.wprev.N500.RInf'),
##D        cuts=100, col.regions=prevR.colors.red(101)
##D       )
## End(Not run)



cleanEx()
nameEx("plot-prevR-method")
### * plot-prevR-method

flush(stderr()); flush(stdout())

### Name: plot,prevR-method
### Title: Plot object of class prevR.
### Aliases: plot plot-methods plot,prevR-method plot,prevR,missing-method
### Keywords: hplot

### ** Examples

## Don't show: 
par(ask = TRUE)
## End Don't show
plot(fdhs, type = "position", main="position", new.window=FALSE, axes=TRUE)
plot(fdhs, type = "c.type", main="c.type", new.window=FALSE)
plot(fdhs, type = "count", main="count", factor.size = 0.1, new.window=FALSE)
plot(fdhs, type = "flower", main="flower", new.window=FALSE)
## Don't show: 
par(ask = FALSE)
## End Don't show



graphics::par(get("par.postscript", pos = 'CheckExEnv'))
cleanEx()
nameEx("prevR-class")
### * prevR-class

flush(stderr()); flush(stdout())

### Name: prevR-class
### Title: Objects of class prevR.
### Aliases: prevR-class
### Keywords: classes

### ** Examples

showClass("prevR")

col <- c(id = "cluster", 
         x = "x",
         y="y",
         n="n",
         pos = "pos",
         c.type = "residence",
         wn="weighted.n",
         wpos="weighted.pos"
        )
dhs <- as.prevR(fdhs.clusters,col, fdhs.boundary)
str(dhs)
print(dhs)

## Not run: 
##D 	dhs <- rings(fdhs,N=c(100,300,500))
##D 	str(dhs)
##D 	print(dhs)
## End(Not run)



cleanEx()
nameEx("prevR-package")
### * prevR-package

flush(stderr()); flush(stdout())

### Name: prevR-package
### Title: Estimating regional trends of a prevalence from a DHS.
### Aliases: prevR-package prevR
### Keywords: package

### ** Examples

## Not run: 
##D par(ask = TRUE)
##D # Creating an object of class prevR
##D col <- c(id = "cluster", 
##D          x = "x",
##D          y = "y",
##D          n = "n",
##D          pos = "pos",
##D          c.type = "residence",
##D          wn = "weighted.n",
##D          wpos = "weighted.pos"
##D         )
##D dhs <- as.prevR(fdhs.clusters,col, fdhs.boundary)
##D 
##D str(dhs)
##D print(dhs)
##D 
##D plot(dhs, main="Clusters position", new.window=FALSE)
##D plot(dhs, type="c.type", main="Clusters by residence", new.window=FALSE)
##D plot(dhs, type="count", main="Observations by cluster", new.window=FALSE)
##D plot(dhs, type="flower", main="Positive cases by cluster", new.window=FALSE)
##D 
##D 
##D # Changing coordinates projection
##D plot(dhs,axes=TRUE,new.window=FALSE)
##D dhs <- changeproj(dhs,
##D        "+proj=utm +zone=30 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")
##D print(dhs)
##D plot(dhs, axes=TRUE, new.window=FALSE)
##D 
##D # Calculating rings of equal number of observations for different values of N
##D dhs <- rings(dhs,N=c(100,200,300,400,500))
##D print(dhs)
##D summary(dhs)
##D 
##D # Prevalence surface for N=300
##D prev.N300 <- kde(dhs, N=300, nb.cells=200)
##D spplot(prev.N300, 'k.wprev.N300.RInf',
##D        cuts=100, col.regions=prevR.colors.red(101),
##D        main="Regional trends of prevalence (N=300)"
##D       )
##D 
##D # Smoothing ring radii surface (spatial interpolation by kriging)
##D radius.N300 <- krige('r.radius', dhs, N=300, nb.cells=200)
##D spplot(radius.N300, 
##D        cuts=100, col.regions=prevR.colors.blue(101),
##D        main="Radius of circle (N=300)"
##D       )
##D par(ask = FALSE)
## End(Not run)



cleanEx()
nameEx("prevR.colors")
### * prevR.colors

flush(stderr()); flush(stdout())

### Name: prevR.colors
### Title: Continuous color palettes.
### Aliases: prevR.colors prevR.demo.pal prevR.colors.red
###   prevR.colors.red.inverse prevR.colors.blue prevR.colors.blue.inverse
###   prevR.colors.green prevR.colors.green.inverse prevR.colors.gray
###   prevR.colors.gray.inverse prevR.colors.qgis.pal
### Keywords: color

### ** Examples

prevR.demo.pal(25)
prevR.colors.red(5)
col2rgb(prevR.colors.red(5))

## Not run: 
##D prevR.colors.qgis.pal('palette.txt', seq(0,25,length.out=100), 'red')
## End(Not run)



cleanEx()
nameEx("print-prevR-method")
### * print-prevR-method

flush(stderr()); flush(stdout())

### Name: print,prevR-method
### Title: Summary of a prevR object.
### Aliases: print-methods print,ANY-method print,prevR-method print

### ** Examples

print(fdhs)
## Not run: 
##D 	dhs <- rings(fdhs,N=c(100,300,500))
##D 	print(dhs)
## End(Not run)



cleanEx()
nameEx("rings-prevR-method")
### * rings-prevR-method

flush(stderr()); flush(stdout())

### Name: rings,prevR-method
### Title: Calculation of rings of equal number of observation and/or equal
###   radius.
### Aliases: rings rings-methods rings,prevR-method
### Keywords: math spatial

### ** Examples
## Not run: 
##D print(fdhs)
##D dhs <- rings(fdhs,N=c(100,200,300,400,500))
##D print(dhs)
## End(Not run)


cleanEx()
nameEx("show-prevR-method")
### * show-prevR-method

flush(stderr()); flush(stdout())

### Name: show,prevR-method
### Title: Summary of a prevR object.
### Aliases: show show-methods show,prevR-method

### ** Examples

fdhs
## Not run: 
##D 	dhs <- rings(fdhs,N=c(100,300,500))
##D 	dhs
## End(Not run)



cleanEx()
nameEx("summary-prevR-method")
### * summary-prevR-method

flush(stderr()); flush(stdout())

### Name: summary,prevR-method
### Title: Detailed summary of the variables of a prevR object
### Aliases: summary-methods summary,prevR-method summary prevRsummary

### ** Examples

summary(fdhs)
## Not run: 
##D 	dhs <- rings(fdhs, N=c(100,300,500))
##D 	summary(dhs)
##D 	summary(dhs, c(0, 0.25, 0.5, 0.75, 1))
## End(Not run)



cleanEx()
nameEx("xyz2dataframe")
### * xyz2dataframe

flush(stderr()); flush(stdout())

### Name: xyz2dataframe
### Title: Convert a surface in xyz to a data frame.
### Aliases: xyz2dataframe
### Keywords: manip

### ** Examples

x <- c(2,4,6,8,10)
y <- x 
op <- KernSur(x,y, xgridsize=50, ygridsize=50,
              correlation=0, 
              xbandwidth=1, ybandwidth=1,
              range.x=c(0,13), range.y=c(0,13)
             )
str(op)

op.df <- xyz2dataframe(op)
str(op.df)



### * <FOOTER>
###
base::cat("Time elapsed: ", proc.time() - base::get("ptime", pos = 'CheckExEnv'),"\n")
grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
