% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{auto_detect_side}
\alias{auto_detect_side}
\title{Detect foot side}
\usage{
auto_detect_side(pressure_data)
}
\arguments{
\item{pressure_data}{List. First item should be a 3D array covering each
timepoint of the measurement. z dimension represents time}
}
\value{
String. "LEFT" or "RIGHT"
}
\description{
Detects which foot plantar pressure data is from (left or
right), usually would only be needed for barefoot pressure plate data.
Generally reliable but may be thrown off by severe deformities or abnormal
walking patterns
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
auto_detect_side(pressure_data)
}
