% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze-preference-data.r
\name{fit_preference_summary}
\alias{fit_preference_summary}
\title{Fit Preference Model from Summary Data}
\usage{
fit_preference_summary(
  x1mean,
  x1var,
  m1,
  x2mean,
  x2var,
  m2,
  y1mean,
  y1var,
  n1,
  y2mean,
  y2var,
  n2,
  xi = 1,
  nstrata = 1,
  alpha = 0.05
)
}
\arguments{
\item{x1mean}{mean of responses for patients choosing treatment 1. If study
is stratified, should be vector with length equal to the
number of strata.}

\item{x1var}{variance of responses for patients choosing treatment 1. If 
study is stratified, should be vector with length equal to the
number of strata.}

\item{m1}{number of patients choosing treatment 1. If study
is stratified, should be vector with length equal to the
number of strata.}

\item{x2mean}{mean of responses for patients choosing treatment 2. If study
is stratified, should be vector with length equal to the
number of strata.}

\item{x2var}{variance of responses for patients choosing treatment 2. If 
study is stratified, should be vector with length equal to the
number of strata.}

\item{m2}{number of patients choosing treatment 2. If study
is stratified, should be vector with length equal to the
number of strata.}

\item{y1mean}{mean of responses for patients randomized to treatment 1. If 
study is stratified, should be vector with length equal to the
number of strata.}

\item{y1var}{variance of responses for patients randomized to treatment 1. 
If study is stratified, should be vector with length equal to the
number of strata.}

\item{n1}{number of patients randomized to treatment 1. If study is 
stratified, should be vector with length equal to the number of 
strata.}

\item{y2mean}{mean of responses for patients randomized to treatment 2. If 
study is stratified, should be vector with length equal to the
number of strata.}

\item{y2var}{variance of responses for patients randomized to treatment 2. 
If study is stratified, should be vector with length equal to the
number of strata.}

\item{n2}{number of patients randomized to treatment 2. If study is 
stratified, should be vector with length equal to the number of 
strata.}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. All vector elements should be numeric 
values between 0 and 1. Default is 1 (i.e. unstratified design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}

\item{alpha}{Type I error rate, used to determine confidence interval level 
for the effect estimates. Default is 0.05 (i.e. 95\% confidence interval)}
}
\description{
Computes the test statistics and p-values for the preference, 
selection, and treatment effects in a two-stage randomized trial using 
summary data.
}
\examples{
# Unstratified

x1mean <- 5
x1var <- 1
m1 <- 15
x2mean <- 7
x2var <- 1.1
m2 <- 35
y1mean <- 6
y1var <- 1
n1 <- 25
y2mean <- 8
y2var <- 1.2
n2 <- 25
fit_preference_summary(x1mean, x2var, m1, x2mean, x2var, m2, y1mean, y1var,
               n1, y2mean, y2var, n2)

# Stratified

x1mean <- c(5, 3)
x1var <- c(1, 1)
m1 <- c(15, 30)
x2mean <- c(7, 7)
x2var <- c(1.1, 3.1)
m2 <- c(35, 40)
y1mean <- c(6, 4)
y1var <- c(1, 2)
n1 <- c(25, 35)
y2mean <- c(8, 12)
y2var <- c(1.2, 1)
n2 <- c(25, 20)
fit_preference_summary(x1mean, x2var, m1, x2mean, x2var, m2, y1mean, y1var,
                       n1, y2mean, y2var, n2, alpha=0.1)
}
\references{
Rucker G (1989). "A two-stage trial design for testing treatment,
self-selection and treatment preference effects." \emph{Stat Med}, 
\strong{8}(4):477-485. 
(\href{https://www.ncbi.nlm.nih.gov/pubmed/2727471}{PubMed})

Cameron B, Esserman D (2016). "Sample Size and Power for a 
Stratified Doubly Randomized Preference Design." 
\emph{Stat Methods Med Res}. 
(\href{https://www.ncbi.nlm.nih.gov/pubmed/27872194}{PubMed})
}
