% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference-trial.r
\name{pt_from_ss}
\alias{pt_from_ss}
\title{Design Preference Trials with Sample Size Constraint(s)}
\usage{
pt_from_ss(ss, pref_effect, selection_effect, treatment_effect, sigma2,
  pref_prop, choice_prop = 0.5, stratum_prop = 1, alpha = 0.05,
  k = 1)
}
\arguments{
\item{ss}{the maximum size of any of the three arms.}

\item{pref_effect}{the effect size of the preference arm (delta_pi).}

\item{selection_effect}{the effect size of selection arm (delta_nu).}

\item{treatment_effect}{the sample size of the treatment arm (delta_tau)}

\item{sigma2}{the variance estimate of the outcome of interest. This 
value should be positive numeric values. If study is stratified, should 
be vector of within-stratum variances with length equal to the number of 
strata in the study.}

\item{pref_prop}{the proportion of patients preferring treatment 1. This
value should be between 0 and 1 (phi).}

\item{choice_prop}{the proportion of patients assigned to choice arm in 
the initial randomization. Should be numeric value between
0 and 1 (default=0.5) (theta).}

\item{stratum_prop}{xi a numeric vector of the proportion of patients in 
each stratum. Length of vector should equal the number of strata in the 
study and sum of vector should be 1. All vector elements should be numeric
values between 0 and 1. Default is 1 (i.e. unstratified design) (xi).}

\item{alpha}{the desired type I error rate (default 0.05)..}

\item{k}{the ratio of treatment A to treatment B in the random arm
(default 1).}
}
\description{
Create a set of preference trials where the maximum 
sample size for an arm is specified.
}
\examples{

# Unstratified trials with power constraints.
pt_from_ss(ss=seq(100, 1000, by=100), pref_effect=1, 
  selection_effect=1, treatment_effect=1, sigma2=1, pref_prop=0.6)

# Stratified trials with power constraints. Note that the proportion
# of patients in the choice arm (choice prop) is fixed for all strata.
pt_from_ss(ss=seq(100, 1000, by=100), pref_effect=1, 
  selection_effect=1, treatment_effect=1,
  sigma2=list(c(1, 0.8)), pref_prop=list(c(0.6, 0.3)),
  choice_prop=0.5, stratum_prop=list(c(0.3, 0.7)))

# or...

pt_from_ss(ss=seq(100, 1000, by=100), pref_effect=1, 
  selection_effect=1, treatment_effect=1,
  sigma2=c(1, 0.8), pref_prop=c(0.6, 0.3),
  choice_prop=0.5, stratum_prop=c(0.3, 0.7))

}
