% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modl.R
\name{modl.trControl}
\alias{modl.trControl}
\title{Control the splitting to train the data}
\usage{
modl.trControl(initialWindow, horizon, fixedWindow, givenSummary = FALSE)
}
\arguments{
\item{initialWindow}{An integer. The initial number of consecutive values in each training set sample. Default value: 30.}

\item{horizon}{An integer. The number of consecutive values in test set sample. Default value: 15.}

\item{fixedWindow}{A logical: if FALSE, the training set always start at the first sample and the training set size will vary over data splits. Default value: TRUE.}

\item{givenSummary}{A logical. Indicates if it should be used the customized summaryFunction(?trainControl for more info) modl.sumFunction or not. Default is FALSE; this will use default \code{caret} metrics.}
}
\value{
trainControl object
}
\description{
Creates the needed \code{caret::trainControl} object to control the training
splitting.
}
\details{
We always split using method "timeslice", wich is the better for time series.
More information on how this works on \url{http://topepo.github.io/caret/data-splitting.html#data-splitting-for-time-series}.
}
\examples{
modl.trControl(initialWindow=30,horizon=15,fixedWindow=TRUE,givenSummary=TRUE)
}
\author{
Alberto Vico Moreno
}
