% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_pi.R
\name{normal_pi}
\alias{normal_pi}
\title{Simple uncalibrated prediction intervals for normal distributed data}
\usage{
normal_pi(
  mu,
  pred_se,
  m = 1,
  q = qnorm(1 - 0.05/2),
  alternative = "both",
  futmat_list = NULL,
  futvec = NULL,
  newdat = NULL,
  histdat = NULL,
  algorithm = NULL
)
}
\arguments{
\item{mu}{overall mean}

\item{pred_se}{standard error of the prediction}

\item{m}{number of future observations}

\item{q}{quantile used for interval calculation}

\item{alternative}{either "both", "upper" or "lower"
\code{alternative} specifies, if a prediction interval or
an upper or a lower prediction limit should be computed}

\item{futmat_list}{used to add the list of future design matrices to the output
if called via \code{lmer_pi_futmat()}}

\item{futvec}{used to add the vector of the historical row numbers that define
the future experimental design to the output if called via \code{lmer_pi_futmat()}}

\item{newdat}{additional argument to specify the actual data set}

\item{histdat}{additional argument to specify the historical data set}

\item{algorithm}{used to define the algorithm for calibration if called via
\code{lmer_pi_...()}. This argument is not of interest for the calculation
of simple uncalibrated intervals}
}
\value{
\code{normal_pi()} returns an object of class \code{c("predint", "normalPI")}
with prediction intervals or limits in the first entry (\code{$prediction}).
}
\description{
\code{normal_pi()} is a helper function that is internally called by the \code{lmer_pi_...()} functions.
 It calculates simple uncalibrated prediction intervals for normal distributed
 observations.
}
\details{
This function returns a simple uncalibrated prediction interval as
given in Menssen and Schaarschmidt 2022
\deqn{[l,u] = \hat{\mu} \pm q \sqrt{\widehat{var}(\hat{\mu}) + \sum_{c=1}^{C+1} \hat{\sigma}^2_c}}

with \eqn{\hat{\mu}} as the expected future observation (historical mean) and
\eqn{\hat{\sigma}^2_c} as the \eqn{c=1, 2, ..., C} variance components and \eqn{\hat{\sigma}^2_{C+1}}
as the residual variance and \eqn{q} as the quantile used for interval calculation. \cr

The direct application of this uncalibrated prediction interval to real life data
is not recommended. Please use the \code{lmer_pi_...()} functions for real life applications.  \cr
}
\examples{

# simple PI
norm_pred <- normal_pi(mu=10, pred_se=3, m=1)
summary(norm_pred)

}
\references{
Menssen and Schaarschmidt (2022): Prediction intervals for all of M future
observations based on linear random effects models. Statistica Neerlandica,
 \doi{10.1111/stan.12260}
}
