% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{c2_dat3}
\alias{c2_dat3}
\title{Cross-classified data (example 3)}
\format{
A \code{data.frame} with 8 rows and 3 columns:
\describe{
  \item{y_ijk}{observations}
  \item{a}{treatment a}
  \item{b}{treatment b}
}
}
\usage{
c2_dat3
}
\description{
c2_dat3 contains data that was sampled from a balanced cross-classified design.
}
\examples{

# loading lme4
library(lme4)

# Fitting a random effects model based on c2_dat_1
fit <- lmer(y_ijk~(1|a)+(1|b)+(1|a:b), c2_dat1)
summary(fit)

#----------------------------------------------------------------------------

### Prediction interval using c2_dat3 as future data
# without printing c2_dat3 in the output
\donttest{
# Row numbers of the historical data c2_dat1 that define the structure of
# the future data c2_dat3
futvec <- c(1, 2, 4, 5, 10, 11, 13, 14)

# Calculating the PI
pred_int <- lmer_pi_futvec(model=fit, futvec=futvec, alternative="both", nboot=100)
summary(pred_int)}

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.

}
\keyword{datasets}
