% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_gam.R, R/prediction.R,
%   R/prediction_Arima.R, R/prediction_ar.R, R/prediction_betareg.R,
%   R/prediction_clm.R, R/prediction_coxph.R, R/prediction_crch.R,
%   R/prediction_glm.R, R/prediction_glmx.R, R/prediction_gls.R,
%   R/prediction_hetglm.R, R/prediction_hxlr.R, R/prediction_ivreg.R,
%   R/prediction_lm.R, R/prediction_loess.R, R/prediction_merMod.R,
%   R/prediction_nls.R, R/prediction_nnet.R, R/prediction_polr.R,
%   R/prediction_rq.R, R/prediction_selection.R, R/prediction_survreg.R,
%   R/prediction_svm.R, R/prediction_svyglm.R
\name{prediction.gam}
\alias{prediction.gam}
\alias{prediction}
\alias{prediction.default}
\alias{prediction.Arima}
\alias{prediction.ar}
\alias{prediction.arima0}
\alias{prediction.betareg}
\alias{prediction.clm}
\alias{prediction.coxph}
\alias{prediction.crch}
\alias{prediction.glm}
\alias{prediction.glmx}
\alias{prediction.gls}
\alias{prediction.hetglm}
\alias{prediction.hxlr}
\alias{prediction.ivreg}
\alias{prediction.lm}
\alias{prediction.loess}
\alias{prediction.merMod}
\alias{prediction.nls}
\alias{prediction.nnet}
\alias{prediction.polr}
\alias{prediction.multinom}
\alias{prediction.rq}
\alias{prediction.selection}
\alias{prediction.survreg}
\alias{prediction.svm}
\alias{prediction.svyglm}
\title{Extract Predictions from a Model Object}
\usage{
\method{prediction}{gam}(model, data = find_data(model, parent.frame()),
  type = c("response", "link", "terms"), ...)

prediction(model, data, ...)

\method{prediction}{default}(model, data = find_data(model, parent.frame()),
  type = "response", ...)

\method{prediction}{Arima}(model, data, ...)

\method{prediction}{ar}(model, data, ...)

\method{prediction}{arima0}(model, data, ...)

\method{prediction}{betareg}(model, data = find_data(model, parent.frame()),
  type = c("response", "link", "precision", "variance", "quantile"), ...)

\method{prediction}{clm}(model, data = find_data(model, parent.frame()), ...)

\method{prediction}{coxph}(model, data = find_data(model, parent.frame()),
  type = c("risk", "expected", "lp"), ...)

\method{prediction}{crch}(model, data = find_data(model),
  type = c("response", "location", "scale", "quantile"), ...)

\method{prediction}{glm}(model, data = find_data(model, parent.frame()),
  type = c("response", "link"), ...)

\method{prediction}{glmx}(model, data = find_data(model, parent.frame()),
  type = c("response", "link"), ...)

\method{prediction}{gls}(model, data, ...)

\method{prediction}{hetglm}(model, data = find_data(model, parent.frame()),
  type = c("response", "link", "scale"), ...)

\method{prediction}{hxlr}(model, data = find_data(model), type = c("class",
  "probability", "cumprob", "location", "scale"), ...)

\method{prediction}{ivreg}(model, data = find_data(model, parent.frame()),
  ...)

\method{prediction}{lm}(model, data = find_data(model, parent.frame()),
  type = "response", ...)

\method{prediction}{loess}(model, data = find_data(model, parent.frame()),
  type = "response", ...)

\method{prediction}{merMod}(model, data = find_data(model),
  type = c("response", "link"), ...)

\method{prediction}{nls}(model, data = find_data(model, parent.frame()), ...)

\method{prediction}{nnet}(model, data = find_data(model, parent.frame()), ...)

\method{prediction}{polr}(model, data = find_data(model, parent.frame()),
  type = NULL, ...)

\method{prediction}{multinom}(model, data = find_data(model, parent.frame()),
  type = NULL, ...)

\method{prediction}{rq}(model, data = find_data(model, parent.frame()),
  type = NULL, ...)

\method{prediction}{selection}(model, data = find_data(model, parent.frame()),
  type = "response", ...)

\method{prediction}{survreg}(model, data = find_data(model, parent.frame()),
  type = c("response", "lp", "quantile", "uquantile"), ...)

\method{prediction}{svm}(model, data = find_data(model, parent.frame()), ...)

\method{prediction}{svyglm}(model, data = find_data(model, parent.frame()),
  type = c("response", "link"), ...)
}
\arguments{
\item{model}{A model object, perhaps returned by \code{\link[stats]{lm}} or \code{\link[stats]{glm}}.}

\item{data}{A data.frame over which to calculate marginal effects. If missing, \code{\link{find_data}} is used to specify the data frame.}

\item{type}{A character string indicating the type of marginal effects to estimate. Mostly relevant for non-linear models, where the reasonable options are \dQuote{response} (the default) or \dQuote{link} (i.e., on the scale of the linear predictor in a GLM). For models of class \dQuote{polr} (from \code{\link[MASS]{polr}}), possible values are \dQuote{class} or \dQuote{probs}; both are returned.}

\item{\dots}{Additional arguments passed to \code{\link[stats]{predict}} methods.}
}
\value{
A data.frame with class \dQuote{prediction} that has a number of rows equal to number of rows in \code{data}, where each row is an observation and the last two columns represent fitted/predicted values (\code{fitted}) and the standard errors thereof (\code{se.fitted}). Additional columns may be reported depending on the object class.
}
\description{
Extract predicted values via \code{\link[stats]{predict}} from a model object, conditional on data
}
\details{
This function is simply a wrapper around \code{\link[stats]{predict}} that returns a data frame containing the value of \code{data} and the predicted values with respect to all variables specified in \code{data}.

Methods are currently implemented for the following object classes:
\itemize{
  \item \dQuote{lm}, see \code{\link[stats]{lm}}
  \item \dQuote{glm}, see \code{\link[stats]{glm}}, \code{\link[MASS]{glm.nb}}, \code{\link[glmx]{glmx}}, \code{\link[glmx]{hetglm}}
  \item \dQuote{ar}, see \code{\link[stats]{ar}}
  \item \dQuote{Arima}, see \code{\link[stats]{arima}}
  \item \dQuote{arima0}, see \code{\link[stats]{arima0}}
  \item \dQuote{betareg}, see \code{\link[betareg]{betareg}}
  \item \dQuote{clm}, see \code{\link[ordinal]{clm}}
  \item \dQuote{coxph}, see \code{\link[survival]{coxph}}
  \item \dQuote{crch}, see \code{\link[crch]{crch}}
  \item \dQuote{gam}, see \code{\link[gam]{gam}}
  \item \dQuote{gls}, see \code{\link[nlme]{gls}}
  \item \dQuote{hxlr}, see \code{\link[crch]{hxlr}}
  \item \dQuote{ivreg}, see \code{\link[AER]{ivreg}}
  \item \dQuote{loess}, see \code{\link[stats]{loess}}
  \item \dQuote{nls}, see \code{\link[stats]{nls}}
  \item \dQuote{nnet}, see \code{\link[nnet]{nnet}}
  \item \dQuote{polr}, see \code{\link[MASS]{polr}}
  \item \dQuote{rq}, see \code{\link[quantreg]{rq}}
  \item \dQuote{selection}, see \code{\link[sampleSelection]{selection}}
  \item \dQuote{survreg}, see \code{\link[survival]{survreg}}
  \item \dQuote{svm}, see \code{\link[e1071]{svm}}
  \item \dQuote{svyglm}, see \code{\link[survey]{svyglm}}
}
}
\examples{
require("datasets")
x <- lm(Petal.Width ~ Sepal.Length * Sepal.Width * Species, data = iris)
# prediction for every case
prediction(x)

# prediction for first case
prediction(x, iris[1,])

# prediction at means/modes of input variables
prediction(x, lapply(iris, mean_or_mode))

}
\seealso{
\code{\link{find_data}}, \code{\link{build_datalist}}, \code{\link{mean_or_mode}}, \code{\link{seq_range}}
}
\keyword{models}
