% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.data.r
\name{read.data}
\alias{precintcon.read.data}
\alias{read.data}
\title{Load a precipitation series}
\usage{
read.data(file, sep = ",", dec = ".", header = TRUE, na.value = NA)
}
\arguments{
\item{file}{a string containing the file path.}

\item{sep}{the character applied for delimited columns. (Default value: ",")}

\item{dec}{the character applied for defined decimal point. (Default value: ".")}

\item{header}{a logical value defining whether the first line of the file refers to column names. (Default value: TRUE)}

\item{na.value}{the value used for representing missing values. (Default value: NA)}
}
\value{
A \code{data frame} containing a representation of the
  data in the \code{file}. The \code{file} is addressed as precintcon.daily or 
  precintcon.monthly depending of its structure.
  
  The file should contains three columns when loading monthly series 
  and thirty three columns when loading daily series.
  
  The first columns refers to years and the second one refers to months.
  When dealing with daily datasets, the thirty one remaining columns refers 
  to the amount of precipitation in the days of the months.
  Otherwise, the remaining column refers to the amount of precipitation in each month.
}
\description{
Load a file with a daily or monthly precipitation series.
}
\examples{
##
# Loading a serie on Windows
\dontrun{d1 <- read.data("C:\\PRECINTCON\\203040.csv", sep = ";", dec = ".", header = TRUE)}

##
# Loading a serie on Unix-like
\dontrun{d1 <- read.data("/home/precintcon/203040.csv", sep = ";", dec = ".", header = TRUE)}
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{daily}}
  \code{\link{monthly}}
  \code{\link{read.table}}
  \code{\link{read.csv}}
  \code{\link{read.csv2}}
}
\keyword{data}
\keyword{file}
\keyword{import}
\keyword{precipitation}
\keyword{read}
\keyword{table}

