% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{coef.pre}
\alias{coef.pre}
\title{Coefficients for the final prediction rule ensemble}
\usage{
\method{coef}{pre}(object, penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{object of class \code{\link{pre}}}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{...}{additional arguments to be passed to \code{\link[glmnet]{coef.cv.glmnet}}.}
}
\value{
returns a dataframe with 3 columns: coefficient, rule (rule or 
variable name) and description (\code{NA} for linear terms, conditions for 
rules).
}
\description{
\code{coef.pre} returns coefficients for prediction rules and linear terms in 
the final ensemble
}
\details{
In some cases, duplicated variable names may appear in the model.
For example, the first variable is a factor named 'V1' and there are also
variables named 'V10' and/or 'V11' and/or 'V12' (etc). Then for 
for the binary factor V1, dummy contrast variables will be created, named 
'V10', 'V11', 'V12' (etc). As should be clear from this example, this yields 
duplicated variable names, which may yield problems, for example in the 
calculation of predictions and importances, later on. This can be prevented 
by renaming factor variables with numbers in their name, prior to analysis.
}
\examples{
\donttest{set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
coefs <- coef(airq.ens)}
}
\seealso{
\code{\link{pre}}, \code{\link{plot.pre}}, 
\code{\link{cvpre}}, \code{\link{importance}}, \code{\link{predict.pre}}, 
\code{\link{interact}}, \code{\link{print.pre}}
}
