% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{explain}
\alias{explain}
\title{Explain predictions from final prediction rule ensemble}
\usage{
explain(object, newdata, penalty.par.val = "lambda.1se", response = 1L,
  plot = TRUE, intercept = FALSE, center.linear = FALSE,
  plot.max.nobs = 4, plot.dim = c(2, 2), plot.obs.names = TRUE,
  pred.type = "response", digits = 3L, cex = 0.8,
  ylab = "Contribution to linear predictor", bar.col = c("#E495A5",
  "#39BEB1"), rule.col = "darkgrey")
}
\arguments{
\item{object}{object of class \code{\link{pre}}.}

\item{newdata}{optional dataframe of new (test) observations, including all
predictor variables used for deriving the prediction rule ensemble.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{response}{numeric or character vector of length one. Specifies the
name or number of the response variable (for multivariate responses) or
the name or number of the factor level (for multinomial responses) for 
which explanations and contributions should be computed and/or plotted.
Only used for\code{pre}s fitted to multivariate or multinomial responses.}

\item{plot}{logical. Should explanations be plotted?}

\item{intercept}{logical. Specifies whether intercept should be included in
explaining predictions.}

\item{center.linear}{logical. Specifies whether linear terms should be
centered with respect to the training sample mean before computing their 
contribution to the predicted value. If \code{intercept = TRUE}, this
will also affect the intercept. That is, the value of the intercept returned
will differ from that of the value returned by the \code{print} method.}

\item{plot.max.nobs}{numeric. Specifies maximum number of observations
for which explanations will be plotted. The default (\code{4}) plots the
explanation for the first four observations supplied in \code{newdata}.}

\item{plot.dim}{numeric vector of length 2. Specifies the number of rows and
columns in the resulting plot.}

\item{plot.obs.names}{logical vector of length 1, NULL, or character vector 
of length \code{nrow(data)} supplying the names that should be used for
individual observations' plots. If \code{TRUE} (default), 
\code{rownames(newdata)} will be used as titles. If \code{NULL},
\code{paste("Observation", 1:nrow(newdata))} will be used as titles. If 
\code{FALSE}, no titles will be plotted.}

\item{pred.type}{character. Specifies the type of predicted values to be 
computed, returned and provided in the plot(s). Note that the computed 
contributions must be additive and are therefore always on the scale of 
the linear predictor.}

\item{digits}{integer. Specifies the number of digits used in depcting the
predicted values in the plot.}

\item{cex}{numeric. Specifies the relative text size of title, tick and axis
labels.}

\item{ylab}{character. Specifies the label for the horizonantal (y-) axis.}

\item{bar.col}{character vector of length two. Specifies the colors to be used for
plotting the positive and negative contributions to the predictions, respectively.}

\item{rule.col}{character. Specifies the color to be used for plotting the rule
descriptions. If \code{NULL}, rule descriptions are not plotted.}
}
\description{
\code{explain} shows which rules apply to which observations and visualizes
the contribution of rules and linear predictors to the predicted values
}
\details{
Provides a graphical depiction of the contribution of rules and
linear terms to the individual predictions (if \code{plot = TRUE}.
Invisibly returns a list with objects \code{predictors} and
\code{contribution}. \code{predictors} contains the values of the rules and
linear terms for each observation in \code{newdata}, for those rules
and linear terms included in the final ensemble with the specified
value of \code{penalty.par.val}. \code{contribution} contains the
values of \code{predictors}, multiplied by the estimated values
of the coefficients in the final ensemble selected with the
specified value of \code{penalty.par.val}.
All contributions are calculated w.r.t. the intercept, by default.
Thus, if a given rule applies to an observation in \code{newdata}, 
the contribution of that rule equals the estimated coefficient of
that rule. If a given rule does not apply to an observation in
\code{newdata}, the contribution of that rule equals 0. 
For linear terms, contributions can be centered, or not (the default).
Thus, by default the contribution of a linear terms for an 
observation in \code{newdata} equals the obeservation's value of the 
linear term, times the estimated coefficient of the linear term.
If \code{center.linear = TRUE}, the contribution of a linear term 
for an observation in \code{newdata} equals (the value of the linear
temr, minus the mean value of the linear term in the training data)
times the estimated coefficient for the linear term.
}
\examples{
\donttest{airq <- airquality[complete.cases(airquality), ]
set.seed(1)
train <- sample(1:nrow(airq), size = 100)
set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airq[train,])
airq.ens.exp <- explain(airq.ens, newdata = airq[-train,])
airq.ens.exp$predictors
airq.ens.exp$contribution

## Can also include intercept in explanation:
airq.ens.exp <- explain(airq.ens, newdata = airq[-train,])

## Fit PRE with linear terms only to illustrate effect of center.linear:
set.seed(42)
airq.ens2 <- pre(Ozone ~ ., data = airq[train,], type = "linear")
## When not centered around their means, Month has negative and 
##   Day has positive contribution:
explain(airq.ens2, newdata = airq[-train,][1:2,],
        penalty.par.val = "lambda.min")$contribution
## After mean centering, contributions of Month and Day have switched
##   sign (for these two observations): 
explain(airq.ens2, newdata = airq[-train,][1:2,], 
        penalty.par.val = "lambda.min", center.linear = TRUE)$contribution
}
}
\seealso{
\code{\link{pre}}, \code{\link{plot.pre}},
\code{\link{coef.pre}}, \code{\link{importance}}, \code{\link{cvpre}},
\code{\link{interact}}, \code{\link{print.pre}}
}
