% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{singleplot}
\alias{singleplot}
\title{Create partial dependence plot for a single variable in a prediction rule 
ensemble (pre)}
\usage{
singleplot(object, varname, penalty.par.val = "lambda.1se",
  nvals = NULL, type = "response", ...)
}
\arguments{
\item{object}{an object of class \code{\link{pre}}}

\item{varname}{character vector of length one, specifying the variable for
which the partial dependence plot should be created. Note that \code{varname}
should correspond to the variable as described in the model formula used
to generate the ensemble (i.e., including functions applied to the variable).}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{nvals}{optional numeric vector of length one. For how many values of x
should the partial dependence plot be created?}

\item{type}{character string. Type of prediction to be plotted on y-axis.
\code{type = "response"} gives fitted values for continuous outputs and
fitted probabilities for nominal outputs. \code{type = "link"} gives fitted
values for continuous outputs and linear predictor values for nominal outputs.}

\item{...}{Further arguments to be passed to 
\code{\link[graphics]{plot.default}}.}
}
\description{
\code{singleplot} creates a partial dependence plot, which shows the effect of
a predictor variable on the ensemble's predictions
}
\details{
By default, a partial dependence plot will be created for each unique
observed value of the specified predictor variable. When the number of unique
observed values is large, this may take a long time to compute. In that case,
specifying the nvals argument can substantially reduce computing time. When the
nvals argument is supplied, values for the minimum, maximum, and (nvals - 2)
intermediate values of the predictor variable will be plotted. Note that nvals
can be specified only for numeric and ordered input variables. If the plot is
requested for a nominal input variable, the \code{nvals} argument will be
ignored and a warning is printed.
}
\examples{
\donttest{set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
singleplot(airq.ens, "Temp")}
}
\seealso{
\code{\link{pre}}, \code{\link{pairplot}}
}
