% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe_miscs.R
\name{print.gpe}
\alias{print.gpe}
\title{Print a General Prediction Ensemble (gpe)}
\usage{
\method{print}{gpe}(x, penalty.par.val = "lambda.1se",
  digits = getOption("digits"), ...)
}
\arguments{
\item{x}{An object of class \code{\link{pre}}.}

\item{penalty.par.val}{character or numeric. Information for which final 
prediction rule ensemble should be printed? The ensemble with penalty 
parameter criterion yielding minimum cv error (\code{"lambda.min"}) 
or penalty parameter yielding error within 1 standard error of minimum cv error 
("\code{lambda.1se}")? Alternatively, a numeric value may be specified, 
corresponding to one of the values of lambda in the sequence used by glmnet,
for which estimated cv error can be inspected by inspecting \code{x$glmnet.fit}
and \code{plot(x$glmnet.fit)}.}

\item{digits}{Number of decimal places to print}

\item{...}{Additional arguments, currently not used.}
}
\description{
Print a General Prediction Ensemble (gpe)
}
\seealso{
\code{\link{print.pre}}
}
