% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe.R
\name{gpe_trees}
\alias{gpe_trees}
\alias{gpe_linear}
\alias{gpe_earth}
\title{Learner Functions Generators for gpe}
\usage{
gpe_trees(..., remove_duplicates_complements = TRUE, mtry = Inf,
  ntrees = 500, maxdepth = 3L, learnrate = 0.01, parallel = FALSE,
  use_grad = TRUE, tree.control = ctree_control(mtry = mtry, maxdepth =
  maxdepth))

gpe_linear(..., winsfrac = 0.025, normalize = TRUE)

gpe_earth(..., degree = 3, nk = 8, normalize = TRUE, ntrain = 100,
  learnrate = 0.1, cor_thresh = 0.99)
}
\arguments{
\item{...}{Currently not used.}

\item{remove_duplicates_complements}{\code{TRUE}. Should rules with complementary or duplicate support be removed?}

\item{mtry}{Number of input variables randomly sampled as candidates at each node for random forest like algorithms. The argument is passed to the tree methods in the \code{partykit} package.}

\item{ntrees}{Number of trees to fit. Will not have an effect if \code{tree.control} is used.}

\item{maxdepth}{Maximum depth of trees. Will not have an effect if \code{tree.control} is used.}

\item{learnrate}{Learning rate for methods. Corresponds to the \eqn{\nu} parameter in Friedman & Popescu (2008).}

\item{parallel}{\code{TRUE}. Should basis functions be found in parallel?}

\item{use_grad}{\code{TRUE}. Should binary outcomes use gradient boosting with regression trees when \code{learnrate > 0}? That is, use \code{\link{ctree}} instead of \code{\link{glmtree}} as in Friedman (2001) with a second order Taylor expansion instead of first order as in Chen and Guestrin (2016).}

\item{tree.control}{\code{\link{ctree_control}} with options for the \code{\link{ctree}} function.}

\item{winsfrac}{Quantile to winsorize linear terms. The value should be in \eqn{[0,0.5)}}

\item{normalize}{\code{TRUE}. Should value be scaled by .4 times the inverse standard deviation? If \code{TRUE}, gives linear terms the same influence as a typical rule.}

\item{degree}{Maximum degree of interactions in \code{\link{earth}} model.}

\item{nk}{Maximum number of basis functions in \code{\link{earth}} model.}

\item{ntrain}{Number of models to fit.}

\item{cor_thresh}{A threshold on the pairwise correlation for removal of basis functions. This is similar to \code{remove_duplicates_complements}. One of the basis functions in pairs where the correlation exceeds the threshold is excluded. \code{NULL} implies no exclusion. Setting a value closer to zero will decrease the time needed to fit the final model.}
}
\value{
A function that has formal arguments \code{formula, data, weights, sample_func, verbose, family, ...}. The function returns a vector with character where each element is a term for the final formula in the call to \code{\link{cv.glmnet}}
}
\description{
Functions to get "learner" functions for \code{\link{gpe}}.
}
\details{
\code{gpe_trees} provides learners for tree method. Either \code{\link{ctree}} or \code{\link{glmtree}} from the \code{partykit} package will be used.

\code{gpe_linear} provides linear terms for the \code{gpe}.

\code{gpe_earth} provides basis functions where each factor is a hinge function. The model is estimated with \code{\link{earth}}.
}
\references{
Hothorn, T., & Zeileis, A. (2015). partykit: A modular toolkit for recursive partytioning in R. \emph{Journal of Machine Learning Research, 16}, 3905-3909.

Friedman, J. H. (1991). Multivariate adaptive regression splines. \emph{The Annals Statistics, 19}(1), 1-67.

Friedman, J. H. (2001). Greedy function approximation: a gradient boosting machine. \emph{The Annals of Applied Statistics, 29}(5), 1189-1232.

Friedman, J. H. (1993). Fast MARS. Dept. of Statistics Technical Report No. 110, Stanford University.

Friedman, J. H., & Popescu, B. E. (2008). Predictive learning via rule ensembles. \emph{The Annals of Applied Statistics, 2}(3), 916-954.

Chen T., & Guestrin C. (2016). Xgboost: A scalable tree boosting system. \emph{Proceedings of the 22Nd ACM SIGKDD International Conference on Knowledge Discovery and Data Mining}. ACM, 2016.
}
\seealso{
\code{\link{gpe}}, \code{\link{rTerm}}, \code{\link{lTerm}}, \code{\link{eTerm}}
}
