% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.logis_fe.R
\name{confint.logis_fe}
\alias{confint.logis_fe}
\title{Get confidence intervals for provider effects or standardized measures from a fitted \code{logis_fe} object}
\usage{
\method{confint}{logis_fe}(
  object,
  parm,
  level = 0.95,
  test = "exact",
  option = "SM",
  stdz = "indirect",
  null = "median",
  measure = c("rate", "ratio"),
  alternative = "two.sided",
  ...
)
}
\arguments{
\item{object}{a model fitted from \code{logis_fe}.}

\item{parm}{specify a subset of providers for which confidence intervals are given.
By default, all providers are included. The class of \code{parm} should match the class of the provider IDs.}

\item{level}{the confidence level. The default value is 0.95.}

\item{test}{a character string specifying the type of testing method. The default is "exact".
\itemize{
\item {\code{"exact"}} exact test.
\item {\code{"wald"}} wald test.
\item {\code{"score"}} score test.
}}

\item{option}{a character string specifying whether the confidence intervals
should be provided for provider effects or standardized measures:
\itemize{
\item {\code{"gamma"}} provider effect.
\item {\code{"SM"}} standardized measures.
}}

\item{stdz}{a character string or a vector specifying the standardization method
if \code{option = "SM"}. See \code{stdz} argument in \code{\link{SM_output.logis_fe}}.}

\item{null}{a character string or a number defining the population norm if \code{option = "SM"}.}

\item{measure}{a character string or a vector indicating whether the output measure is "ratio" or "rate" if \code{option = "SM"}.
Both "rate" and "ratio" will be provided by default.
\itemize{
\item {\code{"rate"}} output the standardized rate. The "rate" has been restricted to 0\% - 100\%.
\item {\code{"ratio"}}  output the standardized ratio.
\item {\code{c("ratio", "rate")}} output both the standardized rate and ratio.
}}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"}, or \code{"less"}.
Note that \code{"gamma"} for argument \code{option} only supports \code{"two.sided"}.}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A dataframe (\code{option = "gamma"}) or a list of data frames (\code{option = "SM"}) containing the point estimate, and lower and upper bounds of the estimate.
}
\description{
Provide confidence intervals for provider effects or standardized measures from a fixed effect logistic model.
}
\details{
The wald test is invalid for extreme providers (i.e. when provider effect goes to infinity).
We suggest using score or exact test to generate confidence intervals.
}
\examples{
data(ExampleDataBinary)
outcome = ExampleDataBinary$Y
covar = ExampleDataBinary$Z
ID = ExampleDataBinary$ID
fit_fe <- logis_fe(Y = outcome, Z = covar, ID = ID, message = FALSE)
confint(fit_fe, option = "gamma")
confint(fit_fe, option = "SM")

}
